/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.metadata.MetadataUtil;
import com.lightcrafts.image.metadata.TIFFMetadataReader;
import com.lightcrafts.image.types.RawImageType;
import java.awt.image.RenderedImage;
import java.io.IOException;

public final class PEFImageType
extends RawImageType {
    public static final PEFImageType INSTANCE = new PEFImageType();
    private static final String[] EXTENSIONS = new String[]{"pef"};

    @Override
    public String[] getExtensions() {
        return EXTENSIONS;
    }

    @Override
    public String getName() {
        return "PEF";
    }

    @Override
    public RenderedImage getPreviewImage(ImageInfo imageInfo, int maxWidth, int maxHeight) throws BadImageFileException, IOException, UnknownImageTypeException {
        return super.getPreviewImage(imageInfo, maxWidth, maxHeight);
    }

    @Override
    public boolean hasFastPreview() {
        return true;
    }

    @Override
    public void readMetadata(ImageInfo imageInfo) throws BadImageFileException, IOException {
        TIFFMetadataReader reader = new TIFFMetadataReader(imageInfo);
        MetadataUtil.removePreviewMetadataFrom(reader.readMetadata());
    }

    private PEFImageType() {
    }
}

