/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.image.types;

import Jama.Matrix;
import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ColorProfileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.libs.LCImageLibException;
import com.lightcrafts.image.libs.LCTIFFReader;
import com.lightcrafts.image.metadata.DCRawMetadataReader;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.XMPMetadataWriter;
import com.lightcrafts.image.types.AuxiliaryImageInfo;
import com.lightcrafts.image.types.DNGImageType;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.RAFImageType;
import com.lightcrafts.image.types.RawImageCache;
import com.lightcrafts.image.types.RawImageInfo;
import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.opimage.CachedImage;
import com.lightcrafts.jai.opimage.RGBDemosaicOpImage;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.Interpolation;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.RasterFactory;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.mediax.jai.TiledImage;
import com.lightcrafts.utils.ColorScience;
import com.lightcrafts.utils.DCRaw;
import com.lightcrafts.utils.ProgressIndicator;
import com.lightcrafts.utils.UserCanceledException;
import com.lightcrafts.utils.filecache.FileCache;
import com.lightcrafts.utils.thread.ProgressThread;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.File;
import java.io.IOException;
import sun.awt.image.ShortInterleavedRaster;

public abstract class RawImageType
extends ImageType {
    private static final boolean CACHE_CONVERSION = true;
    static final boolean USE_EMBEDDED_PREVIEW = false;

    @Override
    public Dimension getDimension(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        AuxiliaryImageInfo auxInfo = imageInfo.getAuxiliaryInfo();
        assert (auxInfo instanceof RawImageInfo);
        DCRaw dcRaw = ((RawImageInfo)auxInfo).getDCRaw();
        return new Dimension(dcRaw.getImageWidth(), dcRaw.getImageHeight());
    }

    static Matrix pseudoinverse(Matrix m) {
        Matrix t = m.transpose();
        return t.times(m).inverse().times(t).transpose();
    }

    static void cam_xyz_coeff(float[][] cam_xyz, float[][] rgb_cam, float[] pre_mul) {
        int i;
        double[][] cam_rgb = new double[3][3];
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < 3; ++k) {
                    double[] dArray = cam_rgb[i];
                    int n = j;
                    dArray[n] = dArray[n] + (double)(cam_xyz[i][k] * ColorScience.XYZToRGBMat[k][j]);
                }
            }
        }
        for (i = 0; i < 3; ++i) {
            int j;
            double num = 0.0;
            for (j = 0; j < 3; ++j) {
                num += cam_rgb[i][j];
            }
            j = 0;
            while (j < 3) {
                double[] dArray = cam_rgb[i];
                int n = j++;
                dArray[n] = dArray[n] / num;
            }
            pre_mul[i] = (float)(1.0 / num);
        }
        float[][] inverse = new Matrix(cam_rgb).inverse().transpose().getArrayFloat();
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int j = 0; j < 3; ++j) {
                rgb_cam[i2][j] = inverse[j][i2];
            }
        }
    }

    @Override
    public synchronized PlanarImage getImage(ImageInfo imageInfo, ProgressThread thread) throws BadImageFileException, ColorProfileException, IOException, UnknownImageTypeException, UserCanceledException {
        Object rgbImage;
        long startTime = System.currentTimeMillis();
        RawImageInfo rawInfo = (RawImageInfo)imageInfo.getAuxiliaryInfo();
        DCRaw dcRaw = rawInfo.getDCRaw();
        if (!dcRaw.decodable() || dcRaw.rawColors() != 3) {
            throw new UnknownImageTypeException("Unsupported Camera");
        }
        ComponentColorModel colorModel = RasterFactory.createComponentColorModel((int)1, (ColorSpace)JAIContext.linearColorSpace, (boolean)false, (boolean)false, (int)1);
        ImageMetadata metadata = imageInfo.getMetadata();
        int imageWidth = metadata.getImageWidth();
        int imageHeight = metadata.getImageHeight();
        String cacheKey = null;
        File imageFile = null;
        FileCache fileCache = RawImageCache.getCacheFor(imageInfo);
        if (fileCache != null) {
            System.out.println("Checking cache for: " + imageInfo);
            long t1 = System.currentTimeMillis();
            cacheKey = RawImageCache.getCacheKeyFor(imageInfo);
            if (cacheKey != null) {
                imageFile = RawImageCache.getCachedImageFileFor(cacheKey);
            }
            if (imageFile != null) {
                String fileName = imageFile.getAbsolutePath();
                try {
                    LCTIFFReader.TIFFImage image = new LCTIFFReader.TIFFImage(fileName);
                    long t2 = System.currentTimeMillis();
                    System.out.println("Retrieved Cached image in " + (t2 - t1) + "ms");
                    return image;
                }
                catch (LCImageLibException e) {
                    e.printStackTrace();
                }
            } else {
                System.out.println("File not in cache.");
            }
        }
        System.out.println("metadata width: " + imageWidth + ", height: " + imageHeight);
        ProgressIndicator indicator = null;
        if (thread != null) {
            indicator = thread.getProgressIndicator();
        }
        if (indicator != null) {
            indicator.setMinimum(0);
            indicator.setMaximum(3);
        }
        int filters = dcRaw.getFilters();
        BufferedImage dcrawImage = (BufferedImage)dcRaw.runDCRaw(DCRaw.dcrawMode.full, false);
        System.out.println("dcraw width: " + dcrawImage.getWidth() + ", height: " + dcrawImage.getHeight());
        if (this instanceof RAFImageType && dcRaw.getSecondaryPixels() && (dcRaw.getCameraMake(true).endsWith("S3PRO") || dcRaw.getCameraMake(true).endsWith("S5PRO"))) {
            int by;
            int bx;
            int ry;
            int rx;
            int rawWidth = dcrawImage.getWidth();
            int rawHeight = dcrawImage.getHeight();
            System.out.println("Filters: 0x" + Long.toString(0xFFFFFFFFL & (long)filters, 16));
            switch (filters) {
                case 0x16161616: {
                    rx = 1;
                    ry = 1;
                    bx = 0;
                    by = 0;
                    break;
                }
                case 0x61616161: {
                    rx = 1;
                    ry = 0;
                    bx = 0;
                    by = 1;
                    break;
                }
                case 0x49494949: {
                    rx = 0;
                    ry = 1;
                    bx = 1;
                    by = 0;
                    break;
                }
                case -1802201964: {
                    rx = 0;
                    ry = 0;
                    bx = 1;
                    by = 1;
                    break;
                }
                case -1: 
                case 0: {
                    rx = 0;
                    ry = 0;
                    bx = 0;
                    by = 0;
                    break;
                }
                default: {
                    throw new UnknownImageTypeException("Unknown Bayer filter pattern.");
                }
            }
            ShortInterleavedRaster dcrawRaster = (ShortInterleavedRaster)dcrawImage.getRaster();
            BufferedImage dcrawImage2 = (BufferedImage)dcRaw.runDCRaw(DCRaw.dcrawMode.full, true);
            ShortInterleavedRaster dcrawRaster2 = (ShortInterleavedRaster)dcrawImage2.getRaster();
            short[] data = dcrawRaster.getDataStorage();
            short[] data2 = dcrawRaster2.getDataStorage();
            float[] cameraMultipliers = dcRaw.getCameraMultipliers();
            float[] secondaryCameraMultipliers = dcRaw.getSecondaryCameraMultipliers();
            float redRatio = secondaryCameraMultipliers[0] / cameraMultipliers[0];
            float blueRatio = secondaryCameraMultipliers[2] / cameraMultipliers[2];
            int tl = 1930;
            int th = 2574;
            for (int y = 0; y < rawHeight; ++y) {
                for (int x = 0; x < rawWidth; ++x) {
                    int d = (int)((float)(0xFFFF & data[y * rawWidth + x]) / 12.73f);
                    if (x >= 0 && y > 0 && x < rawWidth - 1 && y < rawHeight - 1 && d > 1930) {
                        int d2 = 0xFFFF & data2[(y - 1) * (rawWidth - 1) + x];
                        if ((x & 1) == rx && (y & 1) == ry) {
                            d2 = (int)(redRatio * (float)d2);
                        }
                        if ((x & 1) == bx && (y & 1) == by) {
                            d2 = (int)(blueRatio * (float)d2);
                        }
                        if (d < 2574) {
                            float m = (float)(2574 - d) / 644.0f;
                            d = (int)(m * (float)d + (1.0f - m) * (float)d2);
                        } else {
                            d = d2;
                        }
                    }
                    data[y * rawWidth + x] = (short)(0xFFFF & d);
                }
            }
        }
        long dcrawTime = System.currentTimeMillis();
        if (thread != null && thread.isCanceled()) {
            return null;
        }
        if (indicator != null) {
            indicator.incrementBy(1);
        }
        if (dcrawImage.getSampleModel().getNumBands() == 1 && filters != 0 && filters != -1) {
            ImageLayout demosaicLayout = new ImageLayout(0, 0, dcrawImage.getWidth(), dcrawImage.getHeight(), 0, 0, 256, 256, ((ColorModel)colorModel).createCompatibleSampleModel(256, 256), (ColorModel)colorModel);
            rgbImage = new RGBDemosaicOpImage(dcrawImage, null, demosaicLayout, filters);
            if ((this instanceof RAFImageType || this instanceof DNGImageType && dcRaw.getCameraMake(false).startsWith("FUJI")) && dcRaw.getImageWidth() != dcRaw.getRawWidth()) {
                Interpolation interp = Interpolation.getInstance((int)1);
                double angle = 0.7853981633974483;
                if (dcRaw.getModel().equals("FinePix S2Pro")) {
                    angle = 2.356194490192345;
                }
                AffineTransform rotation = AffineTransform.getRotateInstance(angle, rgbImage.getWidth() / 2, rgbImage.getHeight() / 2);
                SampleModel sm = ((ColorModel)colorModel).createCompatibleSampleModel(256, 256);
                ParameterBlock pb2 = new ParameterBlock();
                pb2.addSource(rgbImage);
                pb2.add(rotation);
                pb2.add(interp);
                RenderedOp rotated = JAI.create((String)"Affine", (ParameterBlock)pb2, null);
                ImageLayout rotatedLayout = new ImageLayout(rotated.getBounds().x, rotated.getBounds().y, rotated.getBounds().width, rotated.getBounds().height, rotated.getBounds().x, rotated.getBounds().y, 256, 256, sm, (ColorModel)colorModel);
                RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, rotatedLayout);
                rotated = JAI.create((String)"Affine", (ParameterBlock)pb2, (RenderingHints)hints);
                int width = dcRaw.getImageWidth();
                int height = dcRaw.getImageHeight();
                rgbImage = Functions.crop((RenderedImage)rotated, rotated.getMinX() + (rotated.getWidth() - width) / 2 + 2, rotated.getMinY() + (rotated.getHeight() - height) / 2 + 2, width - 4, height - 4, JAIContext.noCacheHint);
            } else if (dcRaw.getMake().equals("NIKON") && dcRaw.getModel().equals("D1X")) {
                rgbImage = new TiledImage((RenderedImage)rgbImage, true).getSubImage(rgbImage.getMinX() + 5, rgbImage.getMinY() + 5, rgbImage.getWidth() - 10, rgbImage.getHeight() - 10);
                RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
                Interpolation interp = Interpolation.getInstance((int)1);
                SampleModel sm = ((ColorModel)colorModel).createCompatibleSampleModel(256, 256);
                ImageLayout newLayout = new ImageLayout(0, 0, 3 * rgbImage.getWidth() / 4, 3 * rgbImage.getHeight() / 2, 0, 0, 256, 256, sm, (ColorModel)colorModel);
                hints.add(new RenderingHints(JAI.KEY_IMAGE_LAYOUT, newLayout));
                ParameterBlock pb2 = new ParameterBlock();
                pb2.addSource(rgbImage);
                pb2.add(AffineTransform.getScaleInstance(0.75, 1.5));
                pb2.add(interp);
                rgbImage = JAI.create((String)"Affine", (ParameterBlock)pb2, (RenderingHints)hints);
            } else {
                rgbImage = Functions.crop((RenderedImage)rgbImage, rgbImage.getMinX() + 5, rgbImage.getMinY() + 5, rgbImage.getWidth() - 10, rgbImage.getHeight() - 10, JAIContext.noCacheHint);
            }
            ImageLayout cacheLayout = new ImageLayout(0, 0, rgbImage.getWidth(), rgbImage.getHeight(), 0, 0, 256, 256, ((ColorModel)colorModel).createCompatibleSampleModel(256, 256), (ColorModel)colorModel);
            CachedImage cache = new CachedImage(cacheLayout, JAIContext.fileCache);
            long tilingTime = System.currentTimeMillis();
            Rectangle bounds = cache.getBounds();
            bounds.translate(rgbImage.getMinX(), rgbImage.getMinY());
            Point[] tileIndices = rgbImage.getTileIndices(bounds);
            int processors = Runtime.getRuntime().availableProcessors();
            if (processors > 1) {
                int i;
                Thread[] threads = new Thread[processors];
                Object image = rgbImage;
                Point[][] jobs = new Point[processors][];
                int k = 0;
                for (i = 0; i < processors; ++i) {
                    jobs[i] = i < processors - 1 ? new Point[tileIndices.length / processors] : new Point[tileIndices.length - (processors - 1) * (tileIndices.length / processors)];
                    for (int j = 0; j < jobs[i].length; ++j) {
                        jobs[i][j] = tileIndices[k++];
                    }
                }
                for (i = 0; i < processors; ++i) {
                    final Point[] job = jobs[i];
                    Runnable runnable = new Runnable((PlanarImage)image, cache){
                        final /* synthetic */ PlanarImage val$image;
                        final /* synthetic */ CachedImage val$cache;
                        {
                            this.val$image = planarImage;
                            this.val$cache = cachedImage;
                        }

                        @Override
                        public void run() {
                            for (Point ti : job) {
                                Raster tile = this.val$image.getTile(ti.x, ti.y);
                                tile = tile.createTranslatedChild(tile.getMinX() - this.val$image.getMinX(), tile.getMinY() - this.val$image.getMinY());
                                this.val$cache.setData(tile);
                            }
                        }
                    };
                    threads[i] = new Thread(runnable, "RAW Processor " + i);
                    threads[i].start();
                }
                for (i = 0; i < processors; ++i) {
                    try {
                        threads[i].join();
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                for (Point ti : tileIndices) {
                    Raster tile = rgbImage.getTile(ti.x, ti.y);
                    tile = tile.createTranslatedChild(tile.getMinX() - rgbImage.getMinX(), tile.getMinY() - rgbImage.getMinY());
                    cache.setData(tile);
                }
            }
            System.out.println("retiling: " + (System.currentTimeMillis() - tilingTime));
            rgbImage = cache;
        } else {
            ImageLayout layout = new ImageLayout(0, 0, dcrawImage.getWidth(), dcrawImage.getHeight(), 0, 0, 256, 256, ((ColorModel)colorModel).createCompatibleSampleModel(256, 256), (ColorModel)colorModel);
            CachedImage cache = new CachedImage(layout, JAIContext.fileCache);
            for (int x = 0; x <= cache.getMaxTileX(); ++x) {
                for (int y = 0; y <= cache.getMaxTileY(); ++y) {
                    Functions.copyData(cache.getWritableTile(x, y), dcrawImage.getRaster());
                }
            }
            rgbImage = cache;
        }
        if (indicator != null) {
            indicator.incrementBy(1);
        }
        long demosaicTime = System.currentTimeMillis();
        if (indicator != null) {
            indicator.incrementBy(1);
        }
        System.out.println("dcraw: " + (dcrawTime - startTime) + ", demosaic: " + (demosaicTime - dcrawTime));
        if (fileCache != null && imageFile == null && rgbImage != null && cacheKey != null) {
            RawImageCache.add(cacheKey, (RenderedImage)rgbImage);
        }
        return rgbImage;
    }

    @Override
    public RenderedImage getPreviewImage(ImageInfo imageInfo, int maxWidth, int maxHeight) throws BadImageFileException, IOException, UnknownImageTypeException {
        RawImageInfo rawInfo = (RawImageInfo)imageInfo.getAuxiliaryInfo();
        DCRaw dcRaw = rawInfo.getDCRaw();
        if (dcRaw.getThumbHeight() >= 400 && dcRaw.getThumbWidth() >= 600) {
            return dcRaw.runDCRaw(DCRaw.dcrawMode.thumb);
        }
        return dcRaw.runDCRaw(DCRaw.dcrawMode.preview);
    }

    @Override
    public RenderedImage getThumbnailImage(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        RawImageInfo rawInfo = (RawImageInfo)imageInfo.getAuxiliaryInfo();
        DCRaw dcRaw = rawInfo.getDCRaw();
        return dcRaw.runDCRaw(DCRaw.dcrawMode.thumb);
    }

    @Override
    public RawImageInfo newAuxiliaryInfo(ImageInfo imageInfo) {
        return new RawImageInfo(imageInfo);
    }

    @Override
    public void readMetadata(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        new DCRawMetadataReader(imageInfo).readMetadata();
    }

    @Override
    public void writeMetadata(ImageInfo imageInfo) throws BadImageFileException, IOException, UnknownImageTypeException {
        File xmpFile = new File(imageInfo.getXMPFilename());
        ImageMetadata metadata = imageInfo.getCurrentMetadata();
        XMPMetadataWriter.mergeInto(metadata, xmpFile);
        metadata.clearEdited();
    }

    protected RawImageType() {
    }
}

