/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.RasterFactory;
import com.lightcrafts.mediax.jai.TileCache;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;

public class CachedImage
extends PlanarImage {
    private final TileCache cache;

    static ImageLayout getsRGBImageLayout(PlanarImage image) {
        ImageLayout layout = new ImageLayout((RenderedImage)image);
        layout.setColorModel((ColorModel)new ComponentColorModel(JAIContext.sRGBColorSpace, false, false, 1, 0));
        return layout;
    }

    public CachedImage(PlanarImage image, TileCache cache) {
        this(image, cache, false);
        this.setProperty("LCPersistentCache", Boolean.TRUE);
    }

    public CachedImage(PlanarImage image, TileCache cache, boolean castTosRGB) {
        super(castTosRGB ? CachedImage.getsRGBImageLayout(image) : new ImageLayout((RenderedImage)image), null, null);
        this.setProperty("LCPersistentCache", Boolean.TRUE);
        this.cache = cache;
        cache.addTiles((RenderedImage)((Object)this), image.getTileIndices(image.getBounds()), image.getTiles(), null);
    }

    public CachedImage(ImageLayout layout, TileCache cache) {
        super(layout, null, null);
        this.setProperty("LCPersistentCache", Boolean.TRUE);
        this.cache = cache;
    }

    private synchronized WritableRaster addTile(int tileX, int tileY) {
        WritableRaster raster = RasterFactory.createWritableRaster((SampleModel)this.getSampleModel(), (Point)new Point(tileX * this.getTileWidth(), tileY * this.getTileHeight()));
        this.cache.add((RenderedImage)((Object)this), tileX, tileY, (Raster)raster);
        return raster;
    }

    public Raster getTile(int tileX, int tileY) {
        return this.cache.getTile((RenderedImage)((Object)this), tileX, tileY);
    }

    public synchronized WritableRaster getWritableTile(int tileX, int tileY) {
        Raster raster = this.cache.getTile((RenderedImage)((Object)this), tileX, tileY);
        if (raster == null) {
            raster = this.addTile(tileX, tileY);
        }
        return (WritableRaster)raster;
    }

    public synchronized void setData(Raster r) {
        Rectangle rBounds = r.getBounds();
        if ((rBounds = rBounds.intersection(this.getBounds())).isEmpty()) {
            return;
        }
        int txMin = this.XToTileX(rBounds.x);
        int tyMin = this.YToTileY(rBounds.y);
        int txMax = this.XToTileX(rBounds.x + rBounds.width - 1);
        int tyMax = this.YToTileY(rBounds.y + rBounds.height - 1);
        for (int ty = tyMin; ty <= tyMax; ++ty) {
            for (int tx = txMin; tx <= txMax; ++tx) {
                WritableRaster wr = this.getWritableTile(tx, ty);
                if (wr == null) continue;
                Functions.copyData(wr, r);
            }
        }
    }
}

