/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PointOpImage;
import com.lightcrafts.model.ColorSelection;
import com.lightcrafts.utils.ColorScience;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.image.ShortInterleavedRaster;

public class ColorSelectionMaskOpImage
extends PointOpImage {
    private final ColorSelection colorSelection;
    private static final int sMath_scale = 32768;
    private static final int sMath_PI = 102943;
    private static final int sqrt3d2 = (int)(32768.0 * Math.sqrt(3.0) / 2.0);

    private static ImageLayout createLayout(RenderedImage source) {
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
        ImageLayout layout = new ImageLayout(source);
        layout.setColorModel((ColorModel)cm);
        layout.setSampleModel(((ColorModel)cm).createCompatibleSampleModel(source.getWidth(), source.getHeight()));
        return layout;
    }

    public ColorSelectionMaskOpImage(RenderedImage source, ColorSelection colorSelection, Map config) {
        super(source, ColorSelectionMaskOpImage.createLayout(source), config, true);
        this.colorSelection = colorSelection;
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        ShortInterleavedRaster src = (ShortInterleavedRaster)sources[0];
        ByteInterleavedRaster dst = (ByteInterleavedRaster)dest;
        dst = (ByteInterleavedRaster)dst.createChild(destRect.x, destRect.y, destRect.width, destRect.height, destRect.x, destRect.y, null);
        int width = dst.getWidth();
        int height = dst.getHeight();
        byte[] dstData = dst.getDataStorage();
        int[] dstBandOffsets = dst.getDataOffsets();
        int dstLineStride = dst.getScanlineStride();
        short[] srcData = src.getDataStorage();
        int[] srcBandOffsets = src.getDataOffsets();
        int srcLineStride = src.getScanlineStride();
        int dstOffset = dstBandOffsets[0];
        float[] colorSelectionArray = new float[]{this.colorSelection.isHueEnabled ? this.colorSelection.hueLower : 0.0f, this.colorSelection.isHueEnabled ? this.colorSelection.hueLowerFeather : 0.0f, this.colorSelection.isHueEnabled ? this.colorSelection.hueUpper : 1.0f, this.colorSelection.isHueEnabled ? this.colorSelection.hueUpperFeather : 0.0f, this.colorSelection.isLuminosityEnabled ? this.colorSelection.luminosityLower : 0.0f, this.colorSelection.isLuminosityEnabled ? this.colorSelection.luminosityLowerFeather : 0.0f, this.colorSelection.isLuminosityEnabled ? this.colorSelection.luminosityUpper : 1.0f, this.colorSelection.isLuminosityEnabled ? this.colorSelection.luminosityUpperFeather : 0.0f};
        float wr = ColorScience.Wr;
        float wg = ColorScience.Wg;
        float wb = ColorScience.Wb;
        this.nativeUshortLoop(srcData, dstData, width, height, srcBandOffsets, dstOffset, srcLineStride, dstLineStride, colorSelectionArray, wr, wg, wb);
    }

    static int arctan2(int y, int x) {
        int angle;
        int coeff_1 = 25735;
        int coeff_2 = 77205;
        int abs_y = Math.abs(y) + 1;
        if (x >= 0) {
            int r = 32768 * (x - abs_y) / (x + abs_y);
            angle = 25735 - 25735 * r / 32768;
        } else {
            int r = 32768 * (x + abs_y) / (abs_y - x);
            angle = 77205 - 25735 * r / 32768;
        }
        return y < 0 ? -angle : angle;
    }

    public static int hue(int r, int g, int b) {
        int y = sqrt3d2 * (g - b) / 32768;
        int x = r - (g + b) / 2;
        int hue = ColorSelectionMaskOpImage.arctan2(y, x);
        if (hue < 0) {
            hue += 205886;
        }
        return hue;
    }

    static float arctan2(float y, float x) {
        float angle;
        float coeff_1 = 0.7853982f;
        float coeff_2 = 2.3561945f;
        float abs_y = Math.abs(y) + 1.0E-10f;
        if (x >= 0.0f) {
            float r = (x - abs_y) / (x + abs_y);
            angle = 0.7853982f - 0.7853982f * r;
        } else {
            float r = (x + abs_y) / (abs_y - x);
            angle = 2.3561945f - 0.7853982f * r;
        }
        return y < 0.0f ? -angle : angle;
    }

    public static float hue(float r, float g, float b) {
        float x = r - (g + b) / 2.0f;
        float y = (g - b) * (float)Math.sqrt(3.0) / 2.0f;
        float hue = ColorSelectionMaskOpImage.arctan2(y, x);
        if (hue < 0.0f) {
            hue = (float)((double)hue + Math.PI * 2);
        }
        return hue;
    }

    private native void nativeUshortLoop(short[] var1, byte[] var2, int var3, int var4, int[] var5, int var6, int var7, int var8, float[] var9, float var10, float var11, float var12);

    private void ushortLoop(short[] srcData, byte[] dstData, int width, int height, int[] srcBandOffsets, int dstOffset, int srcLineStride, int dstLineStride, float[] colorSelection, float wr, float wg, float wb) {
        int srcROffset = srcBandOffsets[0];
        int srcGOffset = srcBandOffsets[1];
        int srcBOffset = srcBandOffsets[2];
        float hueLower = colorSelection[0];
        float hueLowerFeather = colorSelection[1];
        float hueUpper = colorSelection[2];
        float hueUpperFeather = colorSelection[3];
        float luminosityLower = colorSelection[4];
        float luminosityLowerFeather = colorSelection[5];
        float luminosityUpper = colorSelection[6];
        float luminosityUpperFeather = colorSelection[7];
        int hueOffset = 0;
        if (hueLower < 0.0f || hueLower - hueLowerFeather < 0.0f || hueUpper < 0.0f) {
            hueLower += 1.0f;
            hueUpper += 1.0f;
            hueOffset = 1;
        } else if (hueLower > 1.0f || hueUpper + hueUpperFeather > 1.0f || hueUpper > 1.0f) {
            hueOffset = -1;
        }
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                float colorMask;
                float cmin;
                float cmax;
                float r = 0xFFFF & srcData[3 * col + row * srcLineStride + srcROffset];
                float g = 0xFFFF & srcData[3 * col + row * srcLineStride + srcGOffset];
                float b = 0xFFFF & srcData[3 * col + row * srcLineStride + srcBOffset];
                float f = cmax = r > g ? r : g;
                if (b > cmax) {
                    cmax = b;
                }
                float f2 = cmin = r < g ? r : g;
                if (b < cmin) {
                    cmin = b;
                }
                float saturation = cmax != 0.0f ? (cmax - cmin) / cmax : 0.0f;
                float stmin = 0.01f;
                float stmax = 0.02f;
                if (saturation > 0.01f) {
                    float hue = ColorSelectionMaskOpImage.hue(r, g, b) / ((float)Math.PI * 2);
                    if (hueOffset == 1 && hue < hueLower - hueLowerFeather) {
                        hue += 1.0f;
                    } else if (hueOffset == -1 && (double)hue < 0.5) {
                        hue += 1.0f;
                    }
                    colorMask = hue >= hueLower && hue <= hueUpper ? 1.0f : (hue >= hueLower - hueLowerFeather && hue < hueLower ? (hue - (hueLower - hueLowerFeather)) / hueLowerFeather : (hue > hueUpper && hue <= hueUpper + hueUpperFeather ? (hueUpper + hueUpperFeather - hue) / hueUpperFeather : 0.0f));
                    if (saturation < 0.02f) {
                        colorMask *= (saturation - 0.01f) / 0.01f;
                    }
                } else {
                    colorMask = 0.0f;
                }
                float luminosity = (float)(Math.log((wr * r + wg * g + wb * b) / 256.0f) / (8.0 * Math.log(2.0)));
                float brightnessMask = luminosity >= luminosityLower && luminosity <= luminosityUpper ? 1.0f : (luminosity >= luminosityLower - luminosityLowerFeather && luminosity < luminosityLower ? (luminosity - (luminosityLower - luminosityLowerFeather)) / luminosityLowerFeather : (luminosity > luminosityUpper && luminosity <= luminosityUpper + luminosityUpperFeather ? (luminosityUpper + luminosityUpperFeather - luminosity) / luminosityUpperFeather : 0.0f));
                dstData[col + row * dstLineStride + dstOffset] = (byte)(255.0f * (colorMask *= brightnessMask));
            }
        }
    }
}

