/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.media.jai.util.ImageUtil;
import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PointOpImage;
import com.lightcrafts.mediax.jai.RasterAccessor;
import com.lightcrafts.mediax.jai.RasterFormatTag;
import com.lightcrafts.utils.ColorScience;
import java.awt.Rectangle;
import java.awt.image.PixelInterleavedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;

public class HDROpImage2
extends PointOpImage {
    private static final int div = 2;
    private static final int c = 32768;
    private final double detail;
    private final double shadows;
    private final double highlights;

    public HDROpImage2(RenderedImage source, RenderedImage mask, double shadows, double highlights, double detail, Map config) {
        super(source, mask, new ImageLayout(source), config, true);
        int numBandsSrc = source.getSampleModel().getNumBands();
        int numBandsMask = mask.getSampleModel().getNumBands();
        int dataType = source.getSampleModel().getDataType();
        if (!(source.getSampleModel() instanceof PixelInterleavedSampleModel)) {
            throw new UnsupportedOperationException("Unsupported sample model: " + source.getSampleModel().getClass());
        }
        if (dataType != 1) {
            throw new UnsupportedOperationException("Unsupported data type: " + dataType);
        }
        if (numBandsSrc != 3) {
            throw new UnsupportedOperationException("Only three-banded sources are supported: " + numBandsSrc);
        }
        if (numBandsMask != 1 && numBandsMask != 3) {
            throw new UnsupportedOperationException("Only single-banded or three-banded masks are supported: " + numBandsMask);
        }
        this.permitInPlaceOperation();
        this.detail = 1.0 + (detail - 1.0) / 5.0;
        this.shadows = 1.0 + (shadows - 1.0) / 5.0;
        this.highlights = highlights;
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        RasterFormatTag[] formatTags = this.getFormatTags();
        RasterAccessor s1 = new RasterAccessor(sources[0], destRect, formatTags[0], this.getSourceImage(0).getColorModel());
        RasterAccessor s2 = new RasterAccessor(sources[1], destRect, formatTags[1], this.getSourceImage(1).getColorModel());
        RasterAccessor d = new RasterAccessor((Raster)dest, destRect, formatTags[2], this.getColorModel());
        switch (d.getDataType()) {
            case 1: {
                this.computeRectUShort(s1, s2, d);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported data type: " + d.getDataType());
            }
        }
        if (d.needsClamping()) {
            d.clampDataArrays();
        }
        d.copyDataToRaster();
    }

    private static int softLightBlendPixelsIntensity(int front, int back, short[] intensityTable) {
        int m = front * back / 32768;
        int s = 32768 - (32768 - front) * (32768 - back) / 32768;
        int p = 0xFFFF & intensityTable[back];
        return (32768 - p) * m / 32768 + p * s / 32768;
    }

    private static int softLightBlendPixels(int front, int back) {
        int m = front * back / 32768;
        int s = 32768 - (32768 - front) * (32768 - back) / 32768;
        return (32768 - back) * m / 32768 + back * s / 32768;
    }

    private static double softLightBlendPixels(double front, double back) {
        double m = front * back;
        return (1.0 - back) * m * m;
    }

    private static int screenBlendPixels(int front, int back) {
        return 32768 - (32768 - front) * (32768 - back) / 32768;
    }

    private static int screenBlendPixelsIntensity(int front, int back, short[] intensityTable) {
        int s = 32768 - (32768 - front) * (32768 - back) / 32768;
        int p = 0xFFFF & intensityTable[back];
        return p * s / 32768;
    }

    private static native void cBlendLoop(short[] var0, short[] var1, short[] var2, int[] var3, int[] var4, int[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, float var14, float var15, float var16, float var17, float var18, float var19);

    private static void blendLoop(short[] srcData, short[] maskData, short[] dstData, int[] srcBandOffsets, int[] maskBandOffsets, int[] dstBandOffsets, int dstwidth, int dstheight, int srcLineStride, int srcPixelStride, int maskLineStride, int maskPixelStride, int dstLineStride, int dstPixelStride, float shadows, float detail, float highlights, float wr, float wg, float wb) {
        int maskOffset3;
        int maskOffset2;
        int maskOffset1;
        int srcROffset = srcBandOffsets[0];
        int srcGOffset = srcBandOffsets[1];
        int srcBOffset = srcBandOffsets[2];
        if (maskBandOffsets.length == 3) {
            maskOffset1 = maskBandOffsets[0];
            maskOffset2 = maskBandOffsets[1];
            maskOffset3 = maskBandOffsets[2];
        } else {
            maskOffset2 = maskOffset3 = maskBandOffsets[0];
            maskOffset1 = maskOffset3;
        }
        int dstROffset = dstBandOffsets[0];
        int dstGOffset = dstBandOffsets[1];
        int dstBOffset = dstBandOffsets[2];
        for (int row = 0; row < dstheight; ++row) {
            for (int col = 0; col < dstwidth; ++col) {
                int r = 0xFFFF & srcData[srcPixelStride * col + row * srcLineStride + srcROffset];
                int g = 0xFFFF & srcData[srcPixelStride * col + row * srcLineStride + srcGOffset];
                int b = 0xFFFF & srcData[srcPixelStride * col + row * srcLineStride + srcBOffset];
                double m = (double)(0xFFFF & maskData[maskPixelStride * col + row * maskLineStride + maskOffset1]) / 65535.0;
                if (maskBandOffsets.length == 3) {
                    double um = (double)(0xFFFF & maskData[maskPixelStride * col + row * maskLineStride + maskOffset2]) / 65535.0;
                    um = Math.min(um * um, 1.0);
                    double bm = (double)(0xFFFF & maskData[maskPixelStride * col + row * maskLineStride + maskOffset3]) / 65535.0;
                    m = um * m + (1.0 - um) * bm;
                }
                double y = (wr * (float)r + wg * (float)g + wb * (float)b) / 65535.0f;
                double mm = Math.pow(m, 1.0f / shadows) * Math.pow(y / m, detail);
                double compressedHilights = HDROpImage2.softLightBlendPixels(1.0 - m, y);
                double ratio = (compressedHilights * (double)highlights + (double)(1.0f - highlights)) * mm / y;
                r = (int)((double)r * ratio);
                g = (int)((double)g * ratio);
                b = (int)((double)b * ratio);
                dstData[dstPixelStride * col + row * dstLineStride + dstROffset] = ImageUtil.clampUShort((int)r);
                dstData[dstPixelStride * col + row * dstLineStride + dstGOffset] = ImageUtil.clampUShort((int)g);
                dstData[dstPixelStride * col + row * dstLineStride + dstBOffset] = ImageUtil.clampUShort((int)b);
            }
        }
    }

    private void computeRectUShort(RasterAccessor src, RasterAccessor mask, RasterAccessor dst) {
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int[] srcBandOffsets = src.getBandOffsets();
        short[] srcData = src.getShortDataArrays()[0];
        int maskLineStride = mask.getScanlineStride();
        int maskPixelStride = mask.getPixelStride();
        int[] maskBandOffsets = mask.getBandOffsets();
        short[] maskData = mask.getShortDataArrays()[0];
        int dstwidth = dst.getWidth();
        int dstheight = dst.getHeight();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        int[] dstBandOffsets = dst.getBandOffsets();
        short[] dstData = dst.getShortDataArrays()[0];
        HDROpImage2.cBlendLoop(srcData, maskData, dstData, srcBandOffsets, maskBandOffsets, dstBandOffsets, dstwidth, dstheight, srcLineStride, srcPixelStride, maskLineStride, maskPixelStride, dstLineStride, dstPixelStride, (float)this.shadows, (float)this.detail, (float)this.highlights, ColorScience.Wr, ColorScience.Wg, ColorScience.Wb);
    }
}

