/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PointOpImage;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import sun.awt.image.ShortInterleavedRaster;

public class HighlightRecoveryOpImage
extends PointOpImage {
    private final float[] preMul;
    private final float[][] csMatrix;
    private final float[][] wbMatrix;

    public HighlightRecoveryOpImage(RenderedImage source, float[] preMul, float[][] csMatrix, float[][] wbMatrix, Map config) {
        super(source, new ImageLayout(source), config, true);
        this.permitInPlaceOperation();
        this.preMul = preMul;
        this.csMatrix = csMatrix;
        this.wbMatrix = wbMatrix;
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        this.ushortLoop((ShortInterleavedRaster)sources[0], (ShortInterleavedRaster)dest);
    }

    private native void floatNativeUshortLoop(short[] var1, short[] var2, int[] var3, int[] var4, int var5, int var6, int var7, int var8, int var9, int var10, float[] var11, float[] var12, float[] var13);

    private native void intNativeUshortLoop(short[] var1, short[] var2, int[] var3, int[] var4, int var5, int var6, int var7, int var8, int var9, int var10, float[] var11, float[] var12, float[] var13);

    private native void sseNativeUshortLoop(short[] var1, short[] var2, int[] var3, int[] var4, int var5, int var6, int var7, int var8, int var9, int var10, float[] var11, float[] var12, float[] var13);

    private native void vecNativeUshortLoop(short[] var1, short[] var2, int[] var3, int[] var4, int var5, int var6, int var7, int var8, int var9, int var10, float[] var11, float[] var12, float[] var13);

    protected void ushortLoop(ShortInterleavedRaster src, ShortInterleavedRaster dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        short[] dstData = dst.getDataStorage();
        int[] dstBandOffsets = dst.getDataOffsets();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        short[] srcData = src.getDataStorage();
        int[] srcBandOffsets = src.getDataOffsets();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        float[] csArray = new float[9];
        float[] wbArray = new float[9];
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                csArray[3 * i + j] = this.csMatrix[i][j];
                wbArray[3 * i + j] = this.wbMatrix[i][j];
            }
        }
        this.floatNativeUshortLoop(srcData, dstData, dstBandOffsets, srcBandOffsets, dstLineStride, srcLineStride, dstPixelStride, srcPixelStride, width, height, this.preMul, csArray, wbArray);
    }
}

