/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.jai.opimage;

import com.lightcrafts.mediax.jai.ImageLayout;
import com.lightcrafts.mediax.jai.PointOpImage;
import java.awt.Rectangle;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.util.Map;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.image.ShortInterleavedRaster;

public class RedMaskOpImage
extends PointOpImage {
    private final double tolerance;

    private static ImageLayout createLayout(RenderedImage source) {
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 0);
        ImageLayout layout = new ImageLayout(source);
        layout.setColorModel((ColorModel)cm);
        layout.setSampleModel(((ColorModel)cm).createCompatibleSampleModel(source.getWidth(), source.getHeight()));
        return layout;
    }

    public RedMaskOpImage(RenderedImage source, double tolerance, Map config) {
        super(source, RedMaskOpImage.createLayout(source), config, true);
        this.tolerance = tolerance;
    }

    protected void computeRect(Raster[] sources, WritableRaster dest, Rectangle destRect) {
        this.ushortLoop((ShortInterleavedRaster)sources[0], (ByteInterleavedRaster)dest);
    }

    protected void ushortLoop(ShortInterleavedRaster src, ByteInterleavedRaster dst) {
        int width = src.getWidth();
        int height = src.getHeight();
        byte[] dstData = dst.getDataStorage();
        int[] dstBandOffsets = dst.getDataOffsets();
        int dstLineStride = dst.getScanlineStride();
        int dstPixelStride = dst.getPixelStride();
        short[] srcData = src.getDataStorage();
        int[] srcBandOffsets = src.getDataOffsets();
        int srcLineStride = src.getScanlineStride();
        int srcPixelStride = src.getPixelStride();
        int srcLOffset = srcBandOffsets[0];
        int srcAOffset = srcBandOffsets[1];
        int srcBOffset = srcBandOffsets[2];
        int dstOffset = dstBandOffsets[0];
        int raMin = (int)((71.5 - 48.5 * this.tolerance) * 256.0);
        int raMax = (int)((71.5 + 48.5 * this.tolerance) * 256.0);
        int rbMin = (int)((8.0 - 35.0 * this.tolerance) * 256.0);
        int rbMax = (int)((8.0 + 35.0 * this.tolerance) * 256.0);
        int rraMin = 12390;
        int rraMax = 19353;
        int rrbMin = 5632;
        int rrbMax = 12288;
        int oaMin = 256;
        int oaMax = 15616;
        int obMin = 11776;
        int obMax = 16896;
        int maMin = 1536;
        int maMax = 13824;
        int mbMin = -9728;
        int mbMax = 3584;
        int sLMin = 28415;
        int sLMax = 65278;
        int saMin = 384;
        int saMax = 11040;
        int sbMin = -1200;
        int sbMax = 8880;
        for (int row = 0; row < height; ++row) {
            for (int col = 0; col < width; ++col) {
                int L = 0xFFFF & srcData[3 * col + row * srcLineStride + srcLOffset];
                int a = 0xFFFF & srcData[srcPixelStride * col + row * srcLineStride + srcAOffset] - 32768;
                int b = 0xFFFF & srcData[srcPixelStride * col + row * srcLineStride + srcBOffset] - 32768;
                dstData[dstPixelStride * col + row * dstLineStride + dstOffset] = (a > raMin && a < raMax && b > rbMin && b < rbMax || a > oaMin && a < oaMax && b > obMin && b < obMax || a > rraMin && a < rraMax && b > rrbMin && b < rrbMax) && (L <= sLMin || L >= sLMax || a <= saMin || a >= saMax || b <= sbMin || b >= sbMax) ? -1 : 0;
            }
        }
    }
}

