/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.license;

import com.lightcrafts.license.eSellerateLicenseDialogs;
import com.lightcrafts.ui.toolkit.IconFactory;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UnsupportedLookAndFeelException;

class DialogBackgroundContainer
extends JPanel {
    static Dimension BackgroundSize = new Dimension(640, 480);
    private JComponent background;
    private Box buttonBox;
    private JLabel messageLabel;

    DialogBackgroundContainer(String message, List<JComponent> buttons, boolean expired) {
        this.setLayout(null);
        this.messageLabel = new JLabel(message);
        this.messageLabel.setForeground(Color.white);
        this.add(this.messageLabel);
        this.buttonBox = Box.createHorizontalBox();
        this.buttonBox.add(Box.createHorizontalGlue());
        this.buttonBox.add(Box.createHorizontalStrut(8));
        for (JComponent button : buttons) {
            this.buttonBox.add(button);
            this.buttonBox.add(Box.createHorizontalStrut(8));
        }
        this.buttonBox.add(Box.createHorizontalGlue());
        this.buttonBox.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        this.add(this.buttonBox);
        BufferedImage image = expired ? DialogBackgroundContainer.getSpecificBackground() : DialogBackgroundContainer.getRandomBackground();
        final BufferedImage scaledImage = IconFactory.getScaledImage(image, DialogBackgroundContainer.BackgroundSize.width);
        this.background = new JComponent(){

            @Override
            protected void paintComponent(Graphics graphics) {
                Graphics2D g = (Graphics2D)graphics;
                g.drawRenderedImage(scaledImage, new AffineTransform());
            }

            @Override
            public Dimension getPreferredSize() {
                return BackgroundSize;
            }
        };
        this.add(this.background);
    }

    @Override
    public void doLayout() {
        Dimension size = this.getSize();
        Dimension buttonSize = this.buttonBox.getPreferredSize();
        this.buttonBox.setLocation(0, size.height - buttonSize.height);
        this.buttonBox.setSize(size.width, buttonSize.height);
        this.background.setLocation(0, 0);
        this.background.setSize(size.width, size.height);
        Dimension messageSize = this.messageLabel.getPreferredSize();
        this.messageLabel.setLocation((size.width - messageSize.width) / 2, size.height - buttonSize.height - messageSize.height);
        this.messageLabel.setSize(messageSize);
    }

    @Override
    public Dimension getPreferredSize() {
        return BackgroundSize;
    }

    private static BufferedImage getRandomBackground() {
        Random rand = new Random(System.currentTimeMillis());
        int i = rand.nextInt(3) + 1;
        try {
            Class<eSellerateLicenseDialogs> clazz = eSellerateLicenseDialogs.class;
            URL url = clazz.getResource("resources/" + i + ".jpg");
            BufferedImage image = ImageIO.read(url);
            image = IconFactory.getScaledImage(image, 640);
            return image;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("Couldn't read license image \"" + i + ".jpg\"");
        }
    }

    private static BufferedImage getSpecificBackground() {
        try {
            Class<eSellerateLicenseDialogs> clazz = eSellerateLicenseDialogs.class;
            URL url = clazz.getResource("resources/4.jpg");
            BufferedImage image = ImageIO.read(url);
            image = IconFactory.getScaledImage(image, 640);
            return image;
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException("Couldn't read license image \"4.jpg\"");
        }
    }

    public static void main(String[] args) throws UnsupportedLookAndFeelException {
        String[] texts;
        LinkedList<JComponent> buttons = new LinkedList<JComponent>();
        for (String text : texts = new String[]{"Continue Trial", "Buy Now", "Enter Serial #"}) {
            JButton button = new JButton(text);
            button.setContentAreaFilled(false);
            buttons.add(button);
        }
        JFrame frame = new JFrame();
        frame.getContentPane().add(new DialogBackgroundContainer("Trial will expire", buttons, false));
        frame.pack();
        frame.setLocationRelativeTo(null);
        frame.setVisible(true);
    }
}

