/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.license;

import com.lightcrafts.license.LicenseCheckerModule;
import com.lightcrafts.utils.Version;
import java.util.Calendar;
import java.util.Date;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;

final class ExpirationLicenseCheckerModule
extends LicenseCheckerModule {
    private static final ResourceBundle Resources = ResourceBundle.getBundle("com/lightcrafts/license/resources/ExpirationLicense");
    private static final int DaysBeforeExpiration = Integer.parseInt(Resources.getString("DaysBeforeExpiration"));
    private static final String NeverExpireMessage = Resources.getString("NeverExpireMessage");
    private static final String DaysRemainingMessage = Resources.getString("DaysRemainingMessage");
    private static final String ExpiredMessage = Resources.getString("ExpiredMessage");

    ExpirationLicenseCheckerModule() {
    }

    @Override
    public void run() {
        Date now;
        boolean expired;
        Date expirationDate = ExpirationLicenseCheckerModule.getExpirationDate();
        if (expirationDate != null && (expired = expirationDate.before(now = new Date()))) {
            JOptionPane.showMessageDialog(null, ExpiredMessage);
            System.exit(0);
        }
    }

    @Override
    public String getMessage() {
        Date expirationDate = ExpirationLicenseCheckerModule.getExpirationDate();
        if (expirationDate == null) {
            return NeverExpireMessage;
        }
        Date now = new Date();
        boolean expired = expirationDate.before(now);
        if (expired) {
            return ExpiredMessage;
        }
        int remaining = ExpirationLicenseCheckerModule.getDaysRemaining();
        String days = Integer.toString(remaining);
        return days.replaceFirst("(.*)", DaysRemainingMessage);
    }

    private static Date getExpirationDate() {
        Calendar cal = Calendar.getInstance();
        Date changeDate = Version.getChangeDate();
        if (changeDate != null) {
            cal.setTime(changeDate);
            cal.add(5, DaysBeforeExpiration);
            return cal.getTime();
        }
        return null;
    }

    private static int getDaysRemaining() {
        Date exp = ExpirationLicenseCheckerModule.getExpirationDate();
        Date now = new Date();
        long millis = exp.getTime() - now.getTime();
        return (int)Math.ceil((double)millis / 8.64E7);
    }
}

