/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.license;

import com.lightcrafts.license.ESDLicenseCheckerModule;
import com.lightcrafts.license.ESDLicenseDialogs;
import com.lightcrafts.license.ESDLicenseLibrary;
import com.lightcrafts.license.ESDLicenseManager;
import com.lightcrafts.license.ExpirationLicenseCheckerModule;
import com.lightcrafts.license.LicenseCheckerModule;
import com.lightcrafts.license.LicenseLibrary;
import com.lightcrafts.license.Locale;
import com.lightcrafts.license.eSellerateLicenseDialogs;
import com.lightcrafts.platform.AlertDialog;
import com.lightcrafts.platform.Platform;
import java.awt.EventQueue;
import java.util.Date;

public final class LicenseChecker {
    static boolean m_enteredLicenseKey;
    private static boolean m_hasExpiredTrialLicense;
    private static String m_licenseKey;

    public static String checkLicense() {
        if (Boolean.getBoolean("com.lightcrafts.zorn")) {
            return "License check bypassed.";
        }
        String licenseType = System.getProperty("com.lightcrafts.licensetype");
        LicenseCheckerModule licenseChecker = null;
        if ("ESD".equals(licenseType)) {
            licenseChecker = new ESDLicenseCheckerModule();
        } else if ("TB".equals(licenseType)) {
            licenseChecker = new ExpirationLicenseCheckerModule();
        } else {
            AlertDialog dialog = Platform.getPlatform().getAlertDialog();
            dialog.showAlert(null, Locale.LOCALE.get("NoLicenseTypeDefinedMajor"), Locale.LOCALE.get("NoLicenseTypeDefinedMinor"), 2, Locale.LOCALE.get("QuitButton"));
            System.exit(0);
        }
        try {
            EventQueue.invokeAndWait(licenseChecker);
            m_licenseKey = licenseChecker.getLicenseKey();
            m_hasExpiredTrialLicense = licenseChecker.hasExpiredTrialLicense();
            return licenseChecker.getMessage();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static boolean enteredLicenseKey() {
        return m_enteredLicenseKey;
    }

    public static boolean isBasic() {
        if (m_licenseKey == null) {
            return false;
        }
        eSellerateLicenseDialogs dialogs = new eSellerateLicenseDialogs();
        ESDLicenseLibrary lib = ESDLicenseCheckerModule.getLicenseLibrary(dialogs);
        return lib.isBasicKey(m_licenseKey);
    }

    public static String getLicenseKey() {
        return m_licenseKey;
    }

    public static boolean hasExpiredTrialLicense() {
        return m_hasExpiredTrialLicense;
    }

    public static boolean license() {
        String licenseType = System.getProperty("com.lightcrafts.licensetype");
        if (!"ESD".equals(licenseType) && !Boolean.getBoolean("com.lightcrafts.zorn")) {
            throw new IllegalStateException("Can not license non-ESD.");
        }
        ESDLicenseCheckerModule licenseChecker = new ESDLicenseCheckerModule();
        eSellerateLicenseDialogs dialogs = new eSellerateLicenseDialogs();
        ESDLicenseLibrary lib = ESDLicenseCheckerModule.getLicenseLibrary(dialogs);
        Date date = lib.getTrialLicenseExpirationDate();
        ESDLicenseDialogs.Response response = dialogs.showTrialExpirationDialog(date);
        switch (response) {
            case ESD_BUY_NOW: {
                lib.buyNow();
                return false;
            }
            case ESD_CONTINUE_TRIAL: {
                return false;
            }
            case ESD_ENTER_KEY: {
                return ESDLicenseManager.enterAndValidateKey(lib, dialogs);
            }
        }
        m_licenseKey = licenseChecker.getLicenseKey();
        return m_licenseKey != null;
    }

    public static boolean relicense() {
        String licenseType = System.getProperty("com.lightcrafts.licensetype");
        if (!"ESD".equals(licenseType)) {
            throw new IllegalStateException("Can not relicense non-ESD.");
        }
        ESDLicenseCheckerModule licenseChecker = new ESDLicenseCheckerModule();
        if (licenseChecker.relicense()) {
            m_licenseKey = licenseChecker.getLicenseKey();
            return true;
        }
        return false;
    }

    public static boolean unlicense() {
        String licenseType = System.getProperty("com.lightcrafts.licensetype");
        if (!"ESD".equals(licenseType)) {
            throw new IllegalStateException("Can not unlicense non-ESD.");
        }
        ESDLicenseCheckerModule licenseChecker = new ESDLicenseCheckerModule();
        if (licenseChecker.unlicense()) {
            m_licenseKey = null;
            return true;
        }
        return false;
    }

    static void ensureDisposeOf(final LicenseLibrary lib) {
        Runtime.getRuntime().addShutdownHook(new Thread("LicenseLibrary Disposer"){

            @Override
            public void run() {
                lib.dispose();
            }
        });
    }

    private LicenseChecker() {
    }
}

