/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.license;

import com.lightcrafts.license.DialogBackgroundContainer;
import com.lightcrafts.license.ESDLicenseCheckerModule;
import com.lightcrafts.license.ESDLicenseDialogs;
import com.lightcrafts.license.Locale;
import com.lightcrafts.platform.AlertDialog;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.toolkit.TextAreaFactory;
import com.lightcrafts.utils.TextUtil;
import com.lightcrafts.utils.Version;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

class eSellerateLicenseDialogs
implements ESDLicenseDialogs {
    private static ESDLicenseDialogs.Response m_response;
    private static String m_stickyKey;

    @Override
    public boolean showDeactivateDialog() {
        AlertDialog dialog = Platform.getPlatform().getAlertDialog();
        int button = dialog.showAlert(null, Locale.LOCALE.get("DeactivateQuestionMajor"), Locale.LOCALE.get("DeactivateQuestionMinor"), 1, Locale.LOCALE.get("CancelButton"), Locale.LOCALE.get("DeactivateButton"));
        return button == 1;
    }

    @Override
    public String showEnterKeyDialog(final Pattern keyPattern) {
        JTextArea prompt = TextAreaFactory.createTextArea(Locale.LOCALE.get("EnterSNText1") + "\n\n" + "        XXXXXXXXXX-XXXX-XXXX-XXXX-XXXX-XXXX\n\n" + Locale.LOCALE.get("EnterSNText2"), 30);
        Box promptBox = Box.createHorizontalBox();
        promptBox.add(prompt);
        promptBox.add(Box.createHorizontalGlue());
        final JTextField keyField = new JTextField(m_stickyKey);
        keyField.setBorder(BorderFactory.createLoweredBevelBorder());
        Font staticFont = prompt.getFont();
        Font keyFont = new Font("Monospaced", 0, staticFont.getSize());
        keyField.setFont(keyFont);
        JButton okButton = new JButton(Locale.LOCALE.get("OKButton"));
        JButton cancelButton = new JButton(Locale.LOCALE.get("CancelButton"));
        final JButton pasteButton = new JButton(Locale.LOCALE.get("PasteFromClipboardButton"));
        Box buttons = Box.createHorizontalBox();
        buttons.add(pasteButton);
        buttons.add(Box.createHorizontalGlue());
        buttons.add(Box.createHorizontalStrut(4));
        buttons.add(cancelButton);
        buttons.add(Box.createHorizontalStrut(4));
        buttons.add(okButton);
        Box panel = Box.createVerticalBox();
        panel.add(promptBox);
        panel.add(Box.createVerticalStrut(8));
        panel.add(keyField);
        panel.add(Box.createVerticalStrut(8));
        panel.add(buttons);
        panel.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        panel.registerKeyboardAction(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pasteButton.doClick();
            }
        }, KeyStroke.getKeyStroke(86, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), 2);
        final JDialog dialog = new JDialog((Frame)null, Version.getApplicationName(), true);
        dialog.getContentPane().add(panel);
        dialog.getRootPane().setDefaultButton(okButton);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setResizable(false);
        Color background = dialog.getContentPane().getBackground();
        prompt.setBackground(background);
        dialog.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent e) {
                keyField.requestFocusInWindow();
            }

            @Override
            public void windowLostFocus(WindowEvent e) {
            }
        });
        keyField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                keyField.selectAll();
            }
        });
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                m_stickyKey = keyField.getText();
                m_response = ESDLicenseDialogs.Response.ESD_ENTER_KEY;
                dialog.dispose();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                m_response = ESDLicenseDialogs.Response.ESD_CANCEL;
                dialog.dispose();
            }
        });
        pasteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String key = eSellerateLicenseDialogs.getKeyFromClipboard(keyPattern);
                if (key != null) {
                    keyField.setText(key);
                    keyField.requestFocusInWindow();
                }
            }
        });
        dialog.setVisible(true);
        switch (m_response) {
            case ESD_ENTER_KEY: {
                String key = keyField.getText();
                return key != null ? key.trim().toUpperCase() : null;
            }
        }
        return null;
    }

    @Override
    public void showErrorAlert(String errorMessage, boolean isFatal) {
        AlertDialog dialog = Platform.getPlatform().getAlertDialog();
        dialog.showAlert(null, errorMessage, null, 2, isFatal ? Locale.LOCALE.get("QuitButton") : Locale.LOCALE.get("OKButton"));
    }

    @Override
    public ESDLicenseDialogs.Response showTrialExpirationDialog(Date expiration) {
        String messageText;
        boolean expired = false;
        try {
            expired = ESDLicenseCheckerModule.trialLicenseRefDate.after(expiration);
        }
        catch (Throwable t) {
            return ESDLicenseDialogs.Response.ESD_CONTINUE_TRIAL;
        }
        if (expired) {
            messageText = Locale.LOCALE.get("TrialLicenseExpired");
        } else {
            Date midnight = eSellerateLicenseDialogs.getPrecedingMidnight(expiration);
            if (ESDLicenseCheckerModule.trialLicenseRefDate.compareTo(midnight) > 0) {
                String timeString = eSellerateLicenseDialogs.getTimeOfDayString(expiration);
                messageText = Locale.LOCALE.get("TrialLicenseExpiresToday", timeString);
            } else if (ESDLicenseCheckerModule.trialLicenseRefDate.compareTo(midnight = eSellerateLicenseDialogs.getPrecedingMidnight(midnight)) > 0) {
                String timeString = eSellerateLicenseDialogs.getTimeOfDayString(expiration);
                messageText = Locale.LOCALE.get("TrialLicenseExpiresTomorrow", timeString);
            } else {
                long days = eSellerateLicenseDialogs.getDaysUntil(expiration);
                messageText = Locale.LOCALE.get("TrialLicenseExpiresDays", Long.toString(days));
            }
        }
        JButton continueTrialButton = new JButton(Locale.LOCALE.get("ContinueTrialButton"));
        continueTrialButton.setContentAreaFilled(false);
        JButton buyNowButton = new JButton(Locale.LOCALE.get("BuyNowButton"));
        buyNowButton.setContentAreaFilled(false);
        JButton enterKeyButton = new JButton(Locale.LOCALE.get("EnterSNButton"));
        enterKeyButton.setContentAreaFilled(false);
        LinkedList<JComponent> buttons = new LinkedList<JComponent>();
        buttons.add(buyNowButton);
        buttons.add(enterKeyButton);
        buttons.add(continueTrialButton);
        DialogBackgroundContainer panel = new DialogBackgroundContainer(messageText, buttons, expired);
        final JDialog dialog = new JDialog((Frame)null, Locale.LOCALE.get("TrialExpirationDialogTitle", Version.getApplicationName()), true);
        dialog.setUndecorated(true);
        dialog.getContentPane().add(panel);
        dialog.pack();
        dialog.setLocationRelativeTo(null);
        dialog.setResizable(false);
        continueTrialButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispose();
                m_response = ESDLicenseDialogs.Response.ESD_CONTINUE_TRIAL;
            }
        });
        buyNowButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispose();
                m_response = ESDLicenseDialogs.Response.ESD_BUY_NOW;
            }
        });
        enterKeyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispose();
                m_response = ESDLicenseDialogs.Response.ESD_ENTER_KEY;
            }
        });
        m_response = ESDLicenseDialogs.Response.ESD_QUIT;
        dialog.setVisible(true);
        return m_response;
    }

    @Override
    public String showTryNowDialog() {
        return "Not Used";
    }

    @Override
    public ESDLicenseDialogs.Response showUnlicensedDialog() {
        Object[] buttons = new Object[]{Locale.LOCALE.get("TryNowButton"), Locale.LOCALE.get("EnterSNButton"), Locale.LOCALE.get("QuitButton")};
        int response = JOptionPane.showOptionDialog(null, Locale.LOCALE.get("UnlicensedDialogMessage", Version.getApplicationName()), Locale.LOCALE.get("UnlicensedDialogTitle"), -1, 1, null, buttons, buttons[0]);
        switch (response) {
            case 0: {
                return ESDLicenseDialogs.Response.ESD_TRY_NOW;
            }
            case 1: {
                return ESDLicenseDialogs.Response.ESD_ENTER_KEY;
            }
            case 2: {
                return ESDLicenseDialogs.Response.ESD_QUIT;
            }
        }
        throw new IllegalStateException();
    }

    eSellerateLicenseDialogs() {
        m_stickyKey = "";
    }

    private static long getDaysUntil(Date date) {
        Date givenMidnight = eSellerateLicenseDialogs.getPrecedingMidnight(date);
        Date currentMidnight = eSellerateLicenseDialogs.getPrecedingMidnight(new Date());
        long interval = givenMidnight.getTime() - currentMidnight.getTime();
        return interval / 86400000L;
    }

    private static String getKeyFromClipboard(Pattern keyPattern) {
        String s = null;
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            Clipboard cb = tk.getSystemClipboard();
            Transferable cbContents = cb.getContents(null);
            s = (String)cbContents.getTransferData(DataFlavor.stringFlavor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (s == null) {
            return null;
        }
        return keyPattern.matcher(s = s.trim().toUpperCase()).matches() ? s : null;
    }

    private static Date getPrecedingMidnight(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(date.getTime() - 1000L);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    private static String getTimeOfDayString(Date date) {
        return TextUtil.dateFormat(DateFormat.getTimeInstance(3), date);
    }
}

