/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.Operation;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.SliderConfig;
import java.awt.image.RenderedImage;
import java.text.DecimalFormat;

public class GaussianBlurOperation
extends BlendedOperation {
    private final double step = 0.1;
    static final OperationType type = new OperationTypeImpl("Gaussian Blur");
    private double radius = 5.0;

    public GaussianBlurOperation(Rendering rendering) {
        super(rendering, type);
        this.addSliderKey("Radius");
        DecimalFormat format = new DecimalFormat("0.0");
        this.setSliderConfig("Radius", new SliderConfig(0.1, 500.0, this.radius, 0.1, true, format));
    }

    @Override
    public boolean neutralDefault() {
        return false;
    }

    @Override
    public void setSliderValue(String key, double value) {
        value = this.roundValue(key, value);
        if (key != "Radius" || this.radius == value) {
            return;
        }
        this.radius = value;
        super.setSliderValue(key, value);
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new GaussMask(source, this);
    }

    @Override
    public OperationType getType() {
        return type;
    }

    private class GaussMask
    extends BlendedOperation.BlendedTransform {
        Operation op;

        GaussMask(PlanarImage source, Operation op) {
            super(source);
            this.op = op;
        }

        @Override
        public PlanarImage setFront() {
            return Functions.gaussianBlur((RenderedImage)this.back, GaussianBlurOperation.this.rendering, this.op, GaussianBlurOperation.this.radius * (double)GaussianBlurOperation.this.scale);
        }
    }
}

