/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.mediax.jai.operator.MedianFilterDescriptor;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.SliderConfig;
import com.lightcrafts.utils.ColorScience;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.text.DecimalFormat;

public class NoiseReductionOperation
extends BlendedOperation {
    static final String DENOISE = "Amount";
    static final OperationType type = new OperationTypeImpl("Noise Reduction");
    private int denoiseLevel = 3;

    public NoiseReductionOperation(Rendering rendering) {
        super(rendering, type);
        this.colorInputOnly = true;
        this.addSliderKey(DENOISE);
        DecimalFormat format = new DecimalFormat("0");
        this.setSliderConfig(DENOISE, new SliderConfig(1.0, 10.0, this.denoiseLevel, 1.0, false, format));
    }

    @Override
    public boolean neutralDefault() {
        return false;
    }

    @Override
    public void setSliderValue(String key, double value) {
        value = this.roundValue(key, value);
        if (key != DENOISE || (double)this.denoiseLevel == value) {
            return;
        }
        this.denoiseLevel = (int)value;
        super.setSliderValue(key, value);
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new NoiseReduction(source);
    }

    @Override
    public OperationType getType() {
        return type;
    }

    private class NoiseReduction
    extends BlendedOperation.BlendedTransform {
        RenderedOp denoiser;

        NoiseReduction(PlanarImage source) {
            super(source);
        }

        public PlanarImage setFront1() {
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(this.back);
            return JAI.create((String)"BilateralFilter", (ParameterBlock)pb, null);
        }

        @Override
        public PlanarImage setFront() {
            ColorScience.YST yst = new ColorScience.YST();
            double[][] rgb2yst = yst.fromRGB(this.back.getSampleModel().getDataType());
            double[][] yst2rgb = yst.toRGB(this.back.getSampleModel().getDataType());
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(this.back);
            pb.add(rgb2yst);
            RenderedOp ystImage = JAI.create((String)"BandCombine", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
            pb = new ParameterBlock();
            pb.addSource(ystImage);
            pb.add(new int[]{0});
            RenderedOp y = JAI.create((String)"bandselect", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
            pb = new ParameterBlock();
            pb.addSource(ystImage);
            pb.add(new int[]{1, 2});
            RenderedOp cc = JAI.create((String)"bandselect", (ParameterBlock)pb, null);
            RenderingHints mfHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
            mfHints.add(JAIContext.noCacheHint);
            pb = new ParameterBlock();
            pb.addSource(cc);
            pb.add(MedianFilterDescriptor.MEDIAN_MASK_SQUARE);
            pb.add(new Integer(Math.max(2 * (int)((float)NoiseReductionOperation.this.denoiseLevel * NoiseReductionOperation.this.scale) + 1, 3)));
            this.denoiser = JAI.create((String)"MedianFilter", (ParameterBlock)pb, (RenderingHints)mfHints);
            RenderingHints layoutHints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, Functions.getImageLayout((RenderedImage)ystImage));
            pb = new ParameterBlock();
            pb.addSource(y);
            pb.addSource(this.denoiser);
            layoutHints.add(JAIContext.noCacheHint);
            RenderedOp denoisedyst = JAI.create((String)"BandMerge", (ParameterBlock)pb, (RenderingHints)layoutHints);
            pb = new ParameterBlock();
            pb.addSource(denoisedyst);
            pb.add(yst2rgb);
            return JAI.create((String)"BandCombine", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
        }
    }
}

