/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.Operation;
import com.lightcrafts.model.Preview;
import com.lightcrafts.model.RGBColorSelection;
import com.lightcrafts.model.Region;
import com.lightcrafts.ui.editor.EditorMode;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;

abstract class OperationImpl
implements Operation {
    static final String InteractiveUpdateKey = "InteractiveUpdate";
    static final int DefaultInteractiveUpdateValue = 1;
    protected Rendering rendering;
    private String name;
    private Region region;
    private RGBColorSelection colorSelection = new RGBColorSelection();
    protected boolean invertedRegion;
    private boolean active;
    protected boolean changed;
    private boolean selected = false;
    int batch;
    static int interactiveRegionUpdates;
    protected Transform operation = null;
    protected float scale = 1.0f;
    private boolean deactivatable = true;
    private boolean regionChanged = false;

    OperationImpl(Rendering engine, String name) {
        this.rendering = engine;
        this.name = name;
        this.active = true;
        this.changed = false;
        this.region = null;
    }

    public abstract boolean neutralDefault();

    @Override
    public EditorMode getPreferredMode() {
        return EditorMode.ARROW;
    }

    public String getName() {
        return this.name;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public boolean getSelected() {
        return this.selected;
    }

    @Override
    public void setActivated(boolean active) {
        this.active = active;
        this.settingsChanged();
    }

    public boolean isDeactivatable() {
        return this.deactivatable;
    }

    @Override
    public void setEngineDeActivatable(boolean deactivatable) {
        this.deactivatable = deactivatable;
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    public Region getRegion() {
        return this.region;
    }

    @Override
    public RGBColorSelection getColorSelection() {
        return this.colorSelection;
    }

    @Override
    public void changeBatchStarted() {
        assert (this.batch >= 0);
        ++this.batch;
    }

    @Override
    public void changeBatchEnded() {
        assert (this.batch > 0);
        --this.batch;
        if (this.regionChanged && interactiveRegionUpdates == 1) {
            this.settingsChanged();
            this.regionChanged = false;
        }
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    void settingsChanged() {
        this.changed = true;
        this.rendering.update(this, this.batch != 0);
    }

    @Override
    public void setRegion(Region newRegion) {
        this.region = newRegion;
        this.regionChanged = true;
        if (this.batch == 0 || interactiveRegionUpdates == 0) {
            this.settingsChanged();
        }
    }

    @Override
    public void setColorSelection(RGBColorSelection newColors) {
        this.colorSelection = newColors != null ? newColors : new RGBColorSelection();
        this.settingsChanged();
    }

    @Override
    public void setRegionInverted(boolean inverted) {
        this.invertedRegion = inverted;
        this.settingsChanged();
    }

    protected abstract void updateOp(Transform var1);

    protected abstract Transform createOp(PlanarImage var1);

    public void dispose() {
        if (this.operation != null) {
            this.operation.dispose();
        }
    }

    protected PlanarImage render(PlanarImage source, float scale) {
        if (scale != this.scale) {
            this.scale = scale;
            this.changed = true;
        }
        if (this.operation != null) {
            this.operation.setSource(source);
        }
        if (this.changed || this.operation == null) {
            if (this.operation == null) {
                this.operation = this.createOp(source);
            } else {
                this.updateOp(this.operation);
            }
            this.changed = false;
        }
        return this.operation.render();
    }

    public Preview getPreview() {
        return null;
    }

    @Override
    public boolean hasFooter() {
        return true;
    }

    static {
        Preferences prefs = Preferences.userNodeForPackage(OperationImpl.class);
        prefs.addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                if (evt.getKey().equals(OperationImpl.InteractiveUpdateKey)) {
                    Preferences node = evt.getNode();
                    interactiveRegionUpdates = node.getInt(OperationImpl.InteractiveUpdateKey, 1);
                }
            }
        });
        interactiveRegionUpdates = Preferences.userNodeForPackage(OperationImpl.class).getInt(InteractiveUpdateKey, 1);
    }
}

