/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.model.Engine;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class RawSettings
extends JPanel {
    JFrame frame;
    int count;

    RawSettings(Engine engine) {
        super(new GridBagLayout());
        this.addSlider(new FloatSlider(1000.0, 10000.0){

            @Override
            String getSliderName() {
                return "Temperature";
            }

            @Override
            void sliderMoved(double value) {
                System.out.println("set RAW temperature to " + value);
            }
        });
        this.addSlider(new FloatSlider(1.0, 100.0){

            @Override
            String getSliderName() {
                return "Noise Reduction";
            }

            @Override
            void sliderMoved(double value) {
                System.out.println("set RAW noise reduction to " + value);
            }
        });
        this.addSlider(new FloatSlider(5.0, 25.0){

            @Override
            String getSliderName() {
                return "Exposure";
            }

            @Override
            void sliderMoved(double value) {
                System.out.println("set RAW exposure to " + value);
            }
        });
    }

    private void addSlider(FloatSlider slider) {
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = this.count++;
        c.gridx = 0;
        this.add((Component)new JLabel(slider.getSliderName()), c);
        c.gridx = 1;
        this.add((Component)slider, c);
    }

    void showFrame() {
        this.frame = new JFrame("RAW Settings");
        this.frame.getContentPane().add(this);
        this.frame.pack();
        this.frame.setLocation(0, 0);
        this.frame.setAlwaysOnTop(true);
        this.frame.setVisible(true);
    }

    void hideFrame() {
        this.frame.setVisible(false);
    }

    abstract class FloatSlider
    extends JSlider {
        FloatSlider(final double min, final double max) {
            this.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    int value = FloatSlider.this.getValue();
                    double floatValue = min + (max - min) * ((double)value / 100.0);
                    FloatSlider.this.sliderMoved(floatValue);
                }
            });
        }

        abstract void sliderMoved(double var1);

        abstract String getSliderName();
    }
}

