/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import java.awt.EventQueue;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class RepaintThrasher
extends JFrame
implements ChangeListener {
    private JComponent comp;
    private JButton button;
    private JTextField counter;
    private int count;
    private boolean run;

    RepaintThrasher(JComponent comp) {
        super("Repaint Thrasher");
        this.comp = comp;
        this.button = new JButton("Repaint");
        this.button.addChangeListener(this);
        this.counter = new JTextField();
        this.counter.setColumns(4);
        JPanel panel = new JPanel();
        panel.add(this.button);
        panel.add(this.counter);
        this.setContentPane(panel);
    }

    private void increment() {
        this.counter.setText(Integer.toString(++this.count));
    }

    private void reset() {
        this.count = 0;
        this.counter.setText(Integer.toString(this.count));
    }

    private void queueOneRecursive() {
        if (this.run) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RepaintThrasher.this.comp.repaint();
                    RepaintThrasher.this.increment();
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            RepaintThrasher.this.queueOneRecursive();
                        }
                    });
                }
            });
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        boolean pressed = this.button.getModel().isPressed();
        if (pressed && !this.run) {
            this.run = true;
            this.reset();
            this.queueOneRecursive();
        } else if (this.run && !pressed) {
            this.run = false;
        }
    }
}

