/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.TileComputationListener;
import com.lightcrafts.mediax.jai.TileRequest;
import com.lightcrafts.model.ImageEditor.PaintRequest;
import com.lightcrafts.model.ImageEditor.TileHandler;
import java.awt.Point;
import java.awt.image.Raster;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TileManager
implements TileComputationListener {
    private final List requests = new LinkedList();
    private PaintRequest prefetchRequest = null;

    private void cancelRequest(PaintRequest request) {
        request.cancel();
        if (this.prefetchRequest == request) {
            this.prefetchRequest = null;
        }
    }

    private void cancelPrefetch() {
        if (this.prefetchRequest != null) {
            Iterator it = this.requests.iterator();
            while (it.hasNext()) {
                PaintRequest pr = (PaintRequest)it.next();
                if (pr != this.prefetchRequest) continue;
                it.remove();
                this.cancelRequest(pr);
            }
            this.prefetchRequest = null;
        }
    }

    private void handleTile(TileRequest tileRequest, int tileX, int tileY) {
        Iterator it = this.requests.iterator();
        while (it.hasNext()) {
            PaintRequest pr = (PaintRequest)it.next();
            if (pr.getTileRequest() != tileRequest || !pr.handleTile(tileX, tileY)) continue;
            if (pr.getPendingTiles() == 0) {
                it.remove();
            }
            return;
        }
    }

    public synchronized void cancelTiles(PlanarImage image, int epoch) {
        Iterator it = this.requests.iterator();
        while (it.hasNext()) {
            PaintRequest pr = (PaintRequest)it.next();
            if (pr.image != image || pr.epoch != epoch) continue;
            it.remove();
            this.cancelRequest(pr);
        }
    }

    public synchronized int pendingTiles(PlanarImage image, int epoch) {
        Iterator it = this.requests.iterator();
        int pendingTiles = 0;
        while (it.hasNext()) {
            PaintRequest pr = (PaintRequest)it.next();
            if (pr.image != image || pr.epoch != epoch) continue;
            pendingTiles += pr.getPendingTiles();
        }
        return pendingTiles;
    }

    public synchronized int queueTiles(PlanarImage image, int epoch, List tiles, boolean syncronous, boolean prefetch, TileHandler handler) {
        this.cancelPrefetch();
        Iterator dtit = tiles.iterator();
        block0: while (dtit.hasNext()) {
            Point tile = (Point)dtit.next();
            for (PaintRequest pr : this.requests) {
                if (pr.isCancelled() || pr.image != image || pr.epoch != epoch || !pr.hasTile(tile)) continue;
                dtit.remove();
                continue block0;
            }
        }
        if (!tiles.isEmpty()) {
            Point[] tileIndices = new Point[tiles.size()];
            Iterator it = tiles.iterator();
            int i = 0;
            while (it.hasNext()) {
                tileIndices[i++] = (Point)it.next();
            }
            PaintRequest pr = new PaintRequest(image, epoch, tileIndices, syncronous, prefetch, handler);
            this.requests.add(pr);
            if (prefetch) {
                this.prefetchRequest = pr;
            }
        }
        return tiles.size();
    }

    public synchronized void tileComputed(Object eventSource, TileRequest[] tileRequests, PlanarImage image, int tileX, int tileY, Raster tile) {
        this.handleTile(tileRequests[0], tileX, tileY);
    }

    public synchronized void tileCancelled(Object eventSource, TileRequest[] tileRequests, PlanarImage image, int tileX, int tileY) {
    }

    public synchronized void tileComputationFailure(Object eventSource, TileRequest[] tileRequests, PlanarImage image, int tileX, int tileY, Throwable situation) {
        System.err.println("failed tile " + tileX + ":" + tileY);
        situation.printStackTrace();
    }
}

