/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Transform;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.LookupTableJAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.model.ImageEditor.BlendedOperation;
import com.lightcrafts.model.ImageEditor.OperationTypeImpl;
import com.lightcrafts.model.ImageEditor.Rendering;
import com.lightcrafts.model.OperationType;
import com.lightcrafts.model.WhitePointOperation;
import com.lightcrafts.utils.ColorScience;
import com.lightcrafts.utils.splines;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.image.renderable.ParameterBlock;

class WhitePointOperationImpl
extends BlendedOperation
implements WhitePointOperation {
    private static final OperationType type = new OperationTypeImpl("White Dropper");
    private Color color = Color.gray;
    private Point2D p = null;
    Rendering rendering;

    WhitePointOperationImpl(Rendering rendering) {
        super(rendering, type);
        this.rendering = rendering;
        this.colorInputOnly = true;
    }

    @Override
    public boolean neutralDefault() {
        return true;
    }

    @Override
    public void setWhitePoint(Point2D p) {
        this.p = p;
        this.settingsChanged();
    }

    @Override
    public void setWhitePoint(Color color) {
        this.color = color;
        this.p = null;
        this.settingsChanged();
    }

    @Override
    public Color getWhitePoint() {
        return this.color;
    }

    @Override
    protected void updateOp(Transform op) {
        op.update();
    }

    @Override
    protected BlendedOperation.BlendedTransform createBlendedOp(PlanarImage source) {
        return new WhiteBalance(source);
    }

    @Override
    public OperationType getType() {
        return type;
    }

    static /* synthetic */ Point2D access$000(WhitePointOperationImpl x0) {
        return x0.p;
    }

    static /* synthetic */ Color access$100(WhitePointOperationImpl x0) {
        return x0.color;
    }

    static /* synthetic */ Color access$102(WhitePointOperationImpl x0, Color x1) {
        x0.color = x1;
        return x0.color;
    }

    static /* synthetic */ Point2D access$002(WhitePointOperationImpl x0, Point2D x1) {
        x0.p = x1;
        return x0.p;
    }

    private class WhiteBalance
    extends BlendedOperation.BlendedTransform {
        WhiteBalance(PlanarImage source) {
            super(source);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public PlanarImage setFront() {
            block11: {
                if (WhitePointOperationImpl.access$000(WhitePointOperationImpl.this) == null && WhitePointOperationImpl.access$100(WhitePointOperationImpl.this) == null) break block11;
                pixel = null;
                if (WhitePointOperationImpl.access$000(WhitePointOperationImpl.this) == null) ** GOTO lbl38
                pp = WhitePointOperationImpl.this.rendering.getTransform().transform(WhitePointOperationImpl.access$000(WhitePointOperationImpl.this), null);
                x = (int)pp.getX();
                y = (int)pp.getY();
                if (WhitePointOperationImpl.this.rendering.getScaleFactor() > 1.0f) {
                    x = (int)((float)x / WhitePointOperationImpl.this.rendering.getScaleFactor());
                    y = (int)((float)y / WhitePointOperationImpl.this.rendering.getScaleFactor());
                }
                if (this.back.getBounds().contains(x, y)) {
                    tx = this.back.XToTileX(x);
                    ty = this.back.YToTileY(y);
                    tile = this.back.getTile(tx, ty);
                    averagePixels = 3;
                    if (averagePixels > 1) {
                        tileBounds = tile.getBounds();
                        sampleRect = new Rectangle(x - averagePixels / 2, y - averagePixels / 2, averagePixels, averagePixels);
                        intersection = tileBounds.intersection(sampleRect);
                        pixel = new int[]{0, 0, 0};
                        currentPixel = new int[3];
                        for (i = intersection.x; i < intersection.x + intersection.width; ++i) {
                            for (j = intersection.y; j < intersection.y + intersection.height; ++j) {
                                currentPixel = tile.getPixel(i, j, currentPixel);
                                for (k = 0; k < 3; ++k) {
                                    pixel[k] = (pixel[k] + currentPixel[k]) / 2;
                                }
                            }
                        }
                    } else {
                        pixel = tile.getPixel(x, y, pixel);
                    }
                    WhitePointOperationImpl.access$102(WhitePointOperationImpl.this, new Color(pixel[0] / 256, pixel[1] / 256, pixel[2] / 256));
                    WhitePointOperationImpl.access$002(WhitePointOperationImpl.this, null);
                } else {
                    System.out.println("Something funny here...");
                    return this.back;
lbl38:
                    // 1 sources

                    pixel = new int[]{WhitePointOperationImpl.access$100(WhitePointOperationImpl.this).getRed() * 256, WhitePointOperationImpl.access$100(WhitePointOperationImpl.this).getGreen() * 256, WhitePointOperationImpl.access$100(WhitePointOperationImpl.this).getBlue() * 256};
                }
                tred = pixel[0] / 2 - pixel[2] / 4 - pixel[1] / 4;
                tgreen = pixel[1] / 2 - pixel[0] / 4 - pixel[2] / 4;
                tblue = pixel[2] / 2 - pixel[0] / 4 - pixel[1] / 4;
                lum = (double)(ColorScience.Wr * (float)pixel[0] + ColorScience.Wg * (float)pixel[1] + ColorScience.Wb * (float)pixel[2]) / 65535.0;
                polygon = new double[][]{{0.0, 0.0}, {lum, 0.0}, {1.0, 0.0}};
                polygon[1][1] = -tred / 256.0;
                redCurve = new double[256][2];
                splines.bspline(2, polygon, redCurve);
                polygon[1][1] = -tgreen / 256.0;
                greenCurve = new double[256][2];
                splines.bspline(2, polygon, greenCurve);
                polygon[1][1] = -tblue / 256.0;
                blueCurve = new double[256][2];
                splines.bspline(2, polygon, blueCurve);
                table = new short[3][65536];
                interpolator = new splines.Interpolator();
                for (i = 0; i < 65536; ++i) {
                    table[0][i] = (short)(65535 & (int)Math.min(Math.max((double)i + 255.0 * interpolator.interpolate((double)i / 65535.0, redCurve), 0.0), 65535.0));
                }
                interpolator.reset();
                for (i = 0; i < 65536; ++i) {
                    table[1][i] = (short)(65535 & (int)Math.min(Math.max((double)i + 255.0 * interpolator.interpolate((double)i / 65535.0, greenCurve), 0.0), 65535.0));
                }
                interpolator.reset();
                for (i = 0; i < 65536; ++i) {
                    table[2][i] = (short)(65535 & (int)Math.min(Math.max((double)i + 255.0 * interpolator.interpolate((double)i / 65535.0, blueCurve), 0.0), 65535.0));
                }
                lookupTable = new LookupTableJAI(table, true);
                pb = new ParameterBlock();
                pb.addSource(this.back);
                pb.add(lookupTable);
                return JAI.create((String)"lookup", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
            }
            return this.back;
        }
    }
}

