/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model.ImageEditor;

import com.lightcrafts.jai.JAIContext;
import com.lightcrafts.jai.utils.Functions;
import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.mediax.jai.LookupTableJAI;
import com.lightcrafts.mediax.jai.PlanarImage;
import com.lightcrafts.mediax.jai.RenderedOp;
import com.lightcrafts.model.ImageEditor.ImageEditorEngine;
import com.lightcrafts.model.ImageEditor.PaintListener;
import com.lightcrafts.model.Preview;
import com.lightcrafts.model.Region;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.utils.ColorScience;
import com.lightcrafts.utils.Segment;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.color.ICC_ProfileRGB;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.renderable.ParameterBlock;

public class ZoneFinder
extends Preview
implements PaintListener {
    static final boolean ADJUST_GRAYSCALE = true;
    final boolean colorMode;
    final ImageEditorEngine engine;
    private int currentFocusZone = -1;
    private BufferedImage lastPreview = null;
    RenderedImage zones;
    private Segmenter segmenter = null;

    @Override
    public String getName() {
        return this.colorMode ? "Color Zones" : "Zones";
    }

    @Override
    public void setDropper(Point p) {
    }

    @Override
    public void addNotify() {
        this.engine.update(null, false);
        super.addNotify();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
    }

    @Override
    public void setRegion(Region region) {
    }

    @Override
    public void setSelected(Boolean selected) {
        if (!selected.booleanValue()) {
            this.zones = null;
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.zones == null) {
            this.engine.update(null, false);
        }
        Graphics2D g = (Graphics2D)graphics;
        Shape clip = g.getClip();
        g.setColor(LightZoneSkin.Colors.NeutralGray);
        g.fill(clip);
        if (this.zones != null) {
            AffineTransform transform = new AffineTransform();
            int dx = this.getSize().width > this.zones.getWidth() ? (this.getSize().width - this.zones.getWidth()) / 2 : 0;
            int dy = this.getSize().height > this.zones.getHeight() ? (this.getSize().height - this.zones.getHeight()) / 2 : 0;
            transform.setToTranslation(dx, dy);
            try {
                g.drawRenderedImage(this.zones, transform);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setFocusedZone(int index) {
        this.currentFocusZone = index;
        if (!this.colorMode && this.lastPreview != null) {
            this.zones = ZoneFinder.requantize(this.lastPreview, this.currentFocusZone);
            this.repaint();
        }
    }

    ZoneFinder(ImageEditorEngine engine) {
        this(engine, false);
    }

    ZoneFinder(final ImageEditorEngine engine, boolean colorMode) {
        this.engine = engine;
        this.colorMode = colorMode;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent event) {
                if (ZoneFinder.this.isShowing()) {
                    engine.update(null, false);
                }
            }
        });
    }

    private RenderedImage cropScaleGrayscale(Rectangle visibleRect, RenderedImage image) {
        Rectangle bounds = new Rectangle(image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight());
        if (bounds.contains(visibleRect = bounds.intersection(visibleRect))) {
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(image);
            pb.add((float)visibleRect.x);
            pb.add((float)visibleRect.y);
            pb.add((float)visibleRect.width);
            pb.add((float)visibleRect.height);
            image = JAI.create((String)"Crop", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
        }
        Dimension previewSize = this.getSize();
        float scale = 1.0f;
        if (visibleRect.width > previewSize.width || visibleRect.height > previewSize.height) {
            scale = Math.min((float)previewSize.width / (float)visibleRect.width, (float)previewSize.height / (float)visibleRect.height);
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(image);
            pb.add(scale);
            pb.add(scale);
            image = JAI.create((String)"Scale", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
        }
        if (image instanceof RenderedOp) {
            RenderedOp ropImage = (RenderedOp)image;
            SampleModel sm = ropImage.getSampleModel().createCompatibleSampleModel(image.getWidth(), image.getHeight());
            WritableRaster wr = Raster.createWritableRaster(sm, new Point(ropImage.getMinX(), ropImage.getMinY()));
            ropImage.copyData(wr);
            image = new BufferedImage(ropImage.getColorModel(), wr.createWritableTranslatedChild(0, 0), false, null);
            ropImage.dispose();
        }
        if (!this.colorMode && image.getColorModel().getNumColorComponents() == 3) {
            ICC_Profile profile = ((ICC_ColorSpace)image.getColorModel().getColorSpace()).getProfile();
            if (!(profile instanceof ICC_ProfileRGB)) {
                image = Functions.toColorSpace(image, JAIContext.sRGBColorSpace, null);
                profile = ((ICC_ColorSpace)image.getColorModel().getColorSpace()).getProfile();
            }
            ICC_ProfileRGB rgb_profile = (ICC_ProfileRGB)profile;
            ColorScience.ICC_ProfileParameters pp = new ColorScience.ICC_ProfileParameters(rgb_profile);
            double[][] transform = new double[][]{{pp.W[0], pp.W[1], pp.W[2], 0.0}};
            ParameterBlock pb = new ParameterBlock();
            pb.addSource(image);
            pb.add(transform);
            image = JAI.create((String)"BandCombine", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
        }
        return image;
    }

    private static RenderedImage requantize(RenderedImage image, int focusZone) {
        int i;
        int steps = 16;
        int[] colors = new int[steps + 1];
        for (int i2 = 0; i2 < steps; ++i2) {
            float color = (float)((Math.pow(2.0, (double)i2 * 8.0 / (double)(steps - 1)) - 1.0) / 255.0);
            float[] srgbColor = Functions.fromLinearToCS(JAIContext.systemColorSpace, new float[]{color, color, color});
            colors[i2] = (int)(255.0f * srgbColor[0]);
        }
        colors[steps] = colors[steps - 1];
        byte[][] lut = new byte[3][256];
        int step = 0;
        for (i = 0; i < colors[steps]; ++i) {
            if (i > colors[step]) {
                ++step;
            }
            if (i < (colors[step] + colors[step + 1]) / 2) {
                if (focusZone >= 0 && step == focusZone) {
                    lut[0][i] = (byte)Color.yellow.getRed();
                    lut[1][i] = (byte)Color.yellow.getGreen();
                    lut[2][i] = (byte)Color.yellow.getBlue();
                    continue;
                }
                byte by = (byte)(colors[step] & 0xFF);
                lut[2][i] = by;
                lut[1][i] = by;
                lut[0][i] = by;
                continue;
            }
            byte by = (byte)(colors[step + 1] & 0xFF);
            lut[2][i] = by;
            lut[1][i] = by;
            lut[0][i] = by;
        }
        for (i = colors[steps]; i < 256; ++i) {
            byte by = (byte)colors[steps];
            lut[2][i] = by;
            lut[1][i] = by;
            lut[0][i] = by;
        }
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(new LookupTableJAI(lut));
        return JAI.create((String)"lookup", (ParameterBlock)pb, (RenderingHints)JAIContext.noCacheHint);
    }

    private RenderedImage segment_bah(RenderedImage image) {
        image = Functions.fromByteToUShort(image, null);
        RenderingHints hints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
        ParameterBlock pb = new ParameterBlock();
        pb.addSource(image);
        pb.add(4.0f);
        pb.add(20.0f);
        RenderedOp filtered = JAI.create((String)"BilateralFilter", (ParameterBlock)pb, (RenderingHints)hints);
        filtered = Functions.fromUShortToByte((RenderedImage)filtered, null);
        RenderedImage result = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        filtered.copyData(result.getRaster());
        this.lastPreview = result;
        if (!this.colorMode) {
            result = ZoneFinder.requantize(result, this.currentFocusZone);
        }
        return result;
    }

    private RenderedImage segment(RenderedImage image) {
        WritableRaster raster;
        ColorModel colorModel;
        Rectangle bounds = new Rectangle(image.getMinX(), image.getMinY(), image.getWidth(), image.getHeight());
        byte[] pixels = ((DataBufferByte)image.getData(bounds).getDataBuffer()).getData();
        if (pixels.length != bounds.height * bounds.width * image.getSampleModel().getNumBands()) {
            pixels = (byte[])image.getData(bounds).getDataElements(bounds.x, bounds.y, bounds.width, bounds.height, null);
        }
        pixels = Segment.segmentImage(pixels, this.colorMode ? 3 : 1, bounds.height, bounds.width);
        DataBufferByte data = new DataBufferByte(pixels, pixels.length);
        if (this.colorMode) {
            colorModel = image.getColorModel();
            raster = Raster.createInterleavedRaster(data, bounds.width, bounds.height, 3 * bounds.width, 3, new int[]{0, 1, 2}, null);
        } else {
            raster = Raster.createInterleavedRaster(data, bounds.width, bounds.height, bounds.width, 1, new int[]{0}, null);
            ColorSpace cs = ColorSpace.getInstance(1003);
            colorModel = new ComponentColorModel(cs, new int[]{8}, false, true, 1, 0);
        }
        RenderedImage result = this.lastPreview = new BufferedImage(colorModel, raster, false, null);
        if (!this.colorMode) {
            result = ZoneFinder.requantize(result, this.currentFocusZone);
        }
        return result;
    }

    @Override
    public void paintDone(PlanarImage image, Rectangle visibleRect, boolean synchronous, long time) {
        Dimension previewDimension = this.getSize();
        assert ((image.getColorModel().getColorSpace().isCS_sRGB() || image.getColorModel().getColorSpace() == JAIContext.systemColorSpace) && image.getSampleModel().getDataType() == 0);
        if (previewDimension.getHeight() > 1.0 && previewDimension.getWidth() > 1.0) {
            if (this.segmenter == null || !this.segmenter.isAlive()) {
                this.segmenter = new Segmenter(visibleRect, image);
                this.segmenter.start();
            } else {
                this.segmenter.nextView(visibleRect, image);
            }
        }
    }

    class Segmenter
    extends Thread {
        RenderedImage image;
        RenderedImage nextImage;

        Segmenter(Rectangle visibleRect, PlanarImage image) {
            super("ZoneFinder Histogrammer");
            this.nextImage = null;
            this.image = ZoneFinder.this.cropScaleGrayscale(visibleRect, (RenderedImage)image);
        }

        synchronized void nextView(Rectangle visibleRect, PlanarImage image) {
            this.nextImage = ZoneFinder.this.cropScaleGrayscale(visibleRect, (RenderedImage)image);
        }

        private synchronized boolean getNextView() {
            if (this.nextImage != null) {
                this.image = this.nextImage;
                this.nextImage = null;
                return true;
            }
            return false;
        }

        @Override
        public void run() {
            do {
                if (ZoneFinder.this.getSize().width <= 0 || ZoneFinder.this.getSize().height <= 0) continue;
                ZoneFinder.this.zones = ZoneFinder.this.segment(this.image);
                ZoneFinder.this.repaint();
            } while (this.getNextView());
        }
    }
}

