/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model;

import com.lightcrafts.model.RenderingIntent;
import java.awt.color.ICC_Profile;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;

public final class PrintSettings {
    private ICC_Profile profile;
    private RenderingIntent intent;
    private Rectangle2D bounds;
    private int pixelsPerInch;

    public PrintSettings() {
        this.setPrintBounds(new PageFormat());
        this.setRenderingIntent(RenderingIntent.PERCEPTUAL);
        this.pixelsPerInch = 300;
    }

    public ICC_Profile getColorProfile() {
        return this.profile;
    }

    public void setColorProfile(ICC_Profile profile) {
        this.profile = profile;
    }

    public RenderingIntent getRenderingIntent() {
        return this.intent;
    }

    public void setRenderingIntent(RenderingIntent intent) {
        this.intent = intent;
    }

    public void setPrintBounds(Rectangle2D bounds) {
        this.bounds = (Rectangle2D)bounds.clone();
    }

    public Rectangle2D getPrintBounds() {
        return this.bounds;
    }

    public void setPixelsPerInch(int ppi) {
        this.pixelsPerInch = ppi;
    }

    public int getPixelsPerInch() {
        return this.pixelsPerInch;
    }

    public double getX() {
        return this.bounds.getX();
    }

    public double getY() {
        return this.bounds.getY();
    }

    public double getWidth() {
        return this.bounds.getWidth();
    }

    public double getHeight() {
        return this.bounds.getHeight();
    }

    private void setPrintBounds(PageFormat format) {
        this.bounds = new Rectangle2D.Double(format.getImageableX(), format.getImageableY(), format.getImageableWidth(), format.getImageableHeight());
    }
}

