/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.model;

import java.text.DecimalFormat;

public class SliderConfig {
    private double minValue;
    private double maxValue;
    private double defaultValue;
    private double increment;
    private boolean isLogScale;
    private DecimalFormat format;

    public SliderConfig() {
        this(0.0, 1.0);
    }

    public SliderConfig(double minValue, double maxValue) {
        this(minValue, maxValue, (minValue + maxValue) / 2.0, SliderConfig.getDefaultIncrement(minValue, maxValue));
    }

    public SliderConfig(double minValue, double maxValue, double defaultValue, double increment) {
        this(minValue, maxValue, defaultValue, increment, false, null);
    }

    public SliderConfig(double minValue, double maxValue, double defaultValue, double increment, boolean isLogScale, DecimalFormat format) {
        boolean valid = true;
        valid &= minValue < maxValue;
        valid &= minValue <= defaultValue;
        valid &= defaultValue <= maxValue;
        if (isLogScale) {
            valid &= minValue > 0.0;
        }
        if (!valid) {
            throw new IllegalArgumentException();
        }
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.defaultValue = defaultValue;
        this.increment = increment;
        this.isLogScale = isLogScale;
        this.format = format;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getDefaultValue() {
        return this.defaultValue;
    }

    public double getIncrement() {
        return this.increment;
    }

    public boolean isLogScale() {
        return this.isLogScale;
    }

    public DecimalFormat getDecimalFormat() {
        return this.format;
    }

    public boolean hasText() {
        return this.format != null;
    }

    private static double getDefaultIncrement(double min, double max) {
        return Math.pow(10.0, SliderConfig.log10(max - min) - 3.0);
    }

    private static double log10(double x) {
        return Math.log(x) / Math.log(10.0);
    }
}

