/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.platform;

import com.lightcrafts.platform.AlertDialog;
import com.lightcrafts.platform.DefaultAlertDialog;
import com.lightcrafts.platform.DefaultFileChooser;
import com.lightcrafts.platform.DefaultPrinterLayer;
import com.lightcrafts.platform.DefaultProgressDialog;
import com.lightcrafts.platform.FileChooser;
import com.lightcrafts.platform.PrinterLayer;
import com.lightcrafts.platform.ProgressDialog;
import com.lightcrafts.utils.ColorProfileInfo;
import com.lightcrafts.utils.Version;
import com.lightcrafts.utils.directory.DirectoryMonitor;
import com.lightcrafts.utils.directory.UnixDirectoryMonitor;
import java.awt.Dialog;
import java.awt.color.ICC_Profile;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.filechooser.FileSystemView;

public class Platform {
    public static final Type Linux = Type.Linux;
    public static final Type MacOSX = Type.MacOSX;
    public static final Type Windows = Type.Windows;
    public static final Type Other = Type.Other;
    private PrinterLayer printerLayer = new DefaultPrinterLayer();
    private static Platform m_platform;
    private static final Type m_type;

    public void bringAppToFront(String appName) {
    }

    public AlertDialog getAlertDialog() {
        return DefaultAlertDialog.INSTANCE;
    }

    public File getDefaultImageDirectory() {
        String home = System.getProperty("user.home");
        return new File(home, Version.getApplicationName());
    }

    public String getDisplayNameOf(File file) {
        return this.getFileSystemView().getSystemDisplayName(file);
    }

    public FileChooser getFileChooser() {
        return new DefaultFileChooser();
    }

    public File getLightZoneDocumentsDirectory() {
        String home = System.getProperty("user.home");
        return new File(home, Version.getApplicationName());
    }

    public LookAndFeel getLookAndFeel() {
        return UIManager.getLookAndFeel();
    }

    public DirectoryMonitor getDirectoryMonitor() {
        return new UnixDirectoryMonitor();
    }

    public ICC_Profile getDisplayProfile() {
        return null;
    }

    public Collection<ColorProfileInfo> getExportProfiles() {
        return Collections.emptySet();
    }

    public FileSystemView getFileSystemView() {
        return FileSystemView.getFileSystemView();
    }

    public int getPhysicalMemoryInMB() {
        return 0;
    }

    public String[] getPathComponentsToPicturesFolder() {
        return new String[]{Version.getApplicationName()};
    }

    public static Platform getPlatform() {
        return m_platform;
    }

    public Collection<ColorProfileInfo> getPrinterProfiles() {
        return Collections.emptySet();
    }

    public ProgressDialog getProgressDialog() {
        return new DefaultProgressDialog();
    }

    public static Type getType() {
        return m_type;
    }

    public boolean hasInternetConnectionTo(String hostName) {
        try {
            InetAddress.getByName(hostName);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public void hideFile(File file) throws IOException {
    }

    public boolean isKeyPressed(int keyCode) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The current Platform does not implement isKeyPressed()");
    }

    public File isSpecialFile(File file) {
        return file;
    }

    public void loadLibraries() throws UnsatisfiedLinkError {
    }

    public void makeModal(Dialog dialog) {
        dialog.setModal(true);
    }

    public boolean moveFilesToTrash(String[] pathNames) {
        for (String pathName : pathNames) {
            File file = new File(pathName);
            if (file.delete()) continue;
            return false;
        }
        return true;
    }

    public void readyToOpenFiles() {
    }

    public String resolveAliasFile(File file) {
        return file.getAbsolutePath();
    }

    public boolean showFileInFolder(String path) {
        return false;
    }

    public void showHelpTopic(String topic) {
    }

    public PrinterLayer getPrinterLayer() {
        return this.printerLayer;
    }

    static {
        m_type = Type.getTypeForOS();
        String className = m_type.getPlatformImplementationClassName();
        try {
            m_platform = (Platform)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            m_platform = new Platform();
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
    }

    public static enum Type {
        Linux("com.lightcrafts.platform.linux.LinuxPlatform"),
        MacOSX("com.lightcrafts.platform.macosx.MacOSXPlatform"),
        Windows("com.lightcrafts.platform.windows.WindowsPlatform"),
        Other("com.lightcrafts.platform.Platform");

        private final String m_implementationClassName;

        String getPlatformImplementationClassName() {
            return this.m_implementationClassName;
        }

        static Type getTypeForOS() {
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.startsWith("linux")) {
                return Linux;
            }
            if (osName.equals("mac os x")) {
                return MacOSX;
            }
            if (osName.startsWith("windows")) {
                return Windows;
            }
            return Other;
        }

        private Type(String implementationClassName) {
            this.m_implementationClassName = implementationClassName;
        }
    }
}

