/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.prefs;

import com.lightcrafts.license.LicenseChecker;
import com.lightcrafts.prefs.Locale;
import java.util.prefs.Preferences;
import javax.swing.JComponent;

public class ApplicationMode {
    public static final Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/app");
    private static final String ModeKey = "AppMode";
    private static final String FullModeValue = "Full";
    private static final String BasicModeValue = "Basic";
    private static final String BasicToolTip = Locale.LOCALE.get("UpgradeToolTip");

    public static boolean isBasicMode() {
        return LicenseChecker.isBasic() || Prefs.get(ModeKey, FullModeValue).equals(BasicModeValue);
    }

    public static boolean canSetBasicMode() {
        return !LicenseChecker.isBasic();
    }

    public static void maybeSetToolTip(JComponent comp) {
        if (ApplicationMode.isBasicMode()) {
            String text = comp.getToolTipText();
            comp.setToolTipText(text + " - " + BasicToolTip);
        }
    }

    public static void resetPreference() {
        Prefs.remove(ModeKey);
    }

    static void setBasicMode(boolean on) {
        if (!LicenseChecker.isBasic()) {
            Prefs.putBoolean(ModeKey, on);
        }
    }
}

