/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.prefs;

import com.lightcrafts.prefs.Locale;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JTextArea;

abstract class PreferencesItem {
    private JTextArea help;

    PreferencesItem(JTextArea help) {
        this.help = help;
    }

    void addHelpListeners() {
        MouseAdapter listener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent event) {
                String text = PreferencesItem.this.getHelp(event);
                if (PreferencesItem.this.requiresRestart()) {
                    text = text + "  " + Locale.LOCALE.get("PreferencesRestartMessage");
                }
                PreferencesItem.this.help.setText(text);
            }

            @Override
            public void mouseExited(MouseEvent event) {
                PreferencesItem.this.help.setText("");
            }
        };
        JComponent comp = this.getComponent();
        this.addListenerRecurse(comp, listener);
    }

    private void addListenerRecurse(Component comp, MouseListener listener) {
        comp.addMouseListener(listener);
        if (comp instanceof Container) {
            Component[] children;
            for (Component child : children = ((Container)comp).getComponents()) {
                this.addListenerRecurse(child, listener);
            }
        }
    }

    abstract String getHelp(MouseEvent var1);

    abstract String getLabel();

    abstract boolean requiresRestart();

    abstract JComponent getComponent();

    abstract void commit();

    abstract void restore();
}

