/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.prefs;

import com.lightcrafts.prefs.Locale;
import com.lightcrafts.prefs.PreferencesItem;
import java.awt.event.MouseEvent;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;

class SaveDirectoryItem
extends PreferencesItem {
    private static final String Package = "/com/lightcrafts/app";
    private static final String Key = "SaveByOriginal";
    private static Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/app");
    private JRadioButton originalButton = new JRadioButton(Locale.LOCALE.get("SaveDirectoryOriginalButton"));
    private JRadioButton recentButton = new JRadioButton(Locale.LOCALE.get("SaveDirectoryRecentButton"));
    private ButtonGroup group;

    SaveDirectoryItem(JTextArea help) {
        super(help);
        this.originalButton.setFocusable(false);
        this.recentButton.setFocusable(false);
        this.group = new ButtonGroup();
        this.group.add(this.originalButton);
        this.group.add(this.recentButton);
        this.addHelpListeners();
    }

    @Override
    public String getLabel() {
        return Locale.LOCALE.get("SaveDirectoryItemLabel");
    }

    @Override
    public String getHelp(MouseEvent event) {
        return Locale.LOCALE.get("SaveDirectoryItemHelp");
    }

    @Override
    public boolean requiresRestart() {
        return false;
    }

    @Override
    public JComponent getComponent() {
        Box box = Box.createHorizontalBox();
        box.add(this.originalButton);
        box.add(this.recentButton);
        return box;
    }

    @Override
    public void commit() {
        if (this.originalButton.isSelected()) {
            Prefs.putBoolean(Key, true);
        } else {
            Prefs.putBoolean(Key, false);
        }
    }

    @Override
    public void restore() {
        boolean byOriginal = Prefs.getBoolean(Key, true);
        if (byOriginal) {
            this.originalButton.setSelected(true);
        } else {
            this.recentButton.setSelected(true);
        }
    }
}

