/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.ctrls;

import com.lightcrafts.ui.browser.ctrls.Locale;
import com.lightcrafts.ui.browser.ctrls.NavigationButtons;
import com.lightcrafts.ui.browser.folders.FolderBrowserPane;
import com.lightcrafts.ui.browser.folders.FolderTreeListener;
import com.lightcrafts.ui.toolkit.CoolButton;
import com.lightcrafts.ui.toolkit.IconFactory;
import com.lightcrafts.ui.toolkit.MenuButton;
import com.lightcrafts.ui.toolkit.PaneTitle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class NavigationPane
extends PaneTitle {
    private static Icon ImgFwd = IconFactory.createInvertedIcon(NavigationButtons.class, "forward.png");
    private static Icon ImgBack = IconFactory.createInvertedIcon(NavigationButtons.class, "back.png");
    private static Icon imgPath;

    public NavigationPane(final FolderBrowserPane browser) {
        final CoolButton btnBack = new CoolButton();
        final CoolButton btnForward = new CoolButton();
        MenuButton btnPath = browser.getPathPopupMenu();
        ((AbstractButton)btnBack).setIcon(ImgBack);
        btnBack.setToolTipText(Locale.LOCALE.get("BackToolTip"));
        btnBack.setEnabled(false);
        ((AbstractButton)btnForward).setIcon(ImgFwd);
        btnForward.setToolTipText(Locale.LOCALE.get("ForwardToolTip"));
        btnForward.setEnabled(false);
        btnPath.setIcon(imgPath);
        btnPath.setToolTipText(Locale.LOCALE.get("PathToolTip"));
        btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                browser.goBack();
            }
        });
        btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                browser.goForward();
            }
        });
        browser.addSelectionListener(new FolderTreeListener(){

            @Override
            public void folderSelectionChanged(File folder) {
                btnBack.setEnabled(browser.isBackAvailable());
                btnForward.setEnabled(browser.isForwardAvailable());
            }

            @Override
            public void folderDropAccepted(List<File> files, File folder) {
            }
        });
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createHorizontalStrut(4));
        buttonBox.add(btnBack);
        buttonBox.add(btnForward);
        buttonBox.add(Box.createHorizontalStrut(8));
        buttonBox.add(btnPath);
        buttonBox.add(Box.createHorizontalGlue());
        this.assembleTitle(buttonBox);
    }

    static {
        try {
            imgPath = new ImageIcon(ImageIO.read(NavigationButtons.class.getResource("resources/path.png")));
        }
        catch (IOException e) {
            throw new RuntimeException("Couldn't initialize NavigationButtons", e);
        }
    }
}

