/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.folders;

import com.lightcrafts.ui.browser.folders.FolderTreeModel;
import com.lightcrafts.ui.browser.folders.FolderTreeNode;
import java.awt.Point;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreePath;

class FolderTreeSelectionModel
extends DefaultTreeSelectionModel
implements DropTargetListener {
    private JTree tree;
    private FolderTreeNode dropNode;
    private boolean isDragging;

    FolderTreeSelectionModel(JTree tree) {
        this.tree = tree;
        this.setSelectionMode(1);
    }

    @Override
    public void setSelectionPath(TreePath path) {
        if (!this.isDragging) {
            super.setSelectionPath(path);
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        this.isDragging = true;
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (this.dropNode != null) {
            this.dropNode.setIsDropTarget(false);
            this.notifyChanged(this.dropNode);
        }
        Point p = dtde.getLocation();
        this.dropNode = this.getNodeAt(p);
        if (this.dropNode != null) {
            this.dropNode.setIsDropTarget(true);
            this.notifyChanged(this.dropNode);
        }
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
        this.isDragging = false;
        if (this.dropNode != null) {
            this.dropNode.setIsDropTarget(false);
            this.notifyChanged(this.dropNode);
        }
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        this.isDragging = false;
        if (this.dropNode != null) {
            this.dropNode.setIsDropTarget(false);
            this.notifyChanged(this.dropNode);
        }
    }

    File getDropFolder() {
        if (this.dropNode != null) {
            return this.dropNode.getFile();
        }
        return null;
    }

    private FolderTreeNode getNodeAt(Point p) {
        TreePath path = this.tree.getPathForLocation(p.x, p.y);
        if (path != null) {
            FolderTreeNode node = (FolderTreeNode)path.getLastPathComponent();
            return node;
        }
        return null;
    }

    private void notifyChanged(FolderTreeNode node) {
        FolderTreeModel model = (FolderTreeModel)this.tree.getModel();
        model.nodeChanged(node);
    }
}

