/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.folders;

import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.browser.folders.FolderTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

class WindowsFolderTreeCellRenderer
extends DefaultTreeCellRenderer {
    WindowsFolderTreeCellRenderer() {
    }

    @Override
    public Color getBackgroundNonSelectionColor() {
        return LightZoneSkin.Colors.ToolPanesBackground;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, hasFocus);
        if (value instanceof FolderTreeNode) {
            if (!tree.isEnabled()) {
                this.setEnabled(false);
                if (isLeaf) {
                    this.setDisabledIcon(this.getClosedIcon());
                } else {
                    this.setIconFor((FolderTreeNode)value, isSelected);
                }
            } else {
                this.setEnabled(true);
                if (isLeaf) {
                    this.setIcon(this.getClosedIcon());
                } else {
                    this.setIconFor((FolderTreeNode)value, isSelected);
                }
            }
        }
        return this;
    }

    private void setIconFor(FolderTreeNode node, boolean isSelected) {
        Icon icon;
        if (node.hasSpecialIcon()) {
            File file = node.getFile();
            icon = Platform.getPlatform().getFileSystemView().getSystemIcon(file);
        } else {
            icon = isSelected ? this.getOpenIcon() : this.getClosedIcon();
        }
        this.setIcon(icon);
    }
}

