/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.model;

import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.JPEGImageType;
import com.lightcrafts.image.types.LZNImageType;
import com.lightcrafts.image.types.MultipageTIFFImageType;
import com.lightcrafts.image.types.RawImageType;
import com.lightcrafts.image.types.SidecarJPEGImageType;
import com.lightcrafts.image.types.SidecarTIFFImageType;
import com.lightcrafts.image.types.TIFFImageType;
import com.lightcrafts.ui.browser.model.ImageDatum;

public abstract class ImageDatumType {
    public static final ImageDatumType RawType = new ImageDatumType("RAW"){

        @Override
        public boolean isInstance(ImageDatum datum) {
            ImageMetadata meta = datum.getMetadata(true);
            ImageType type = meta.getImageType();
            return type instanceof RawImageType;
        }

        @Override
        public boolean hasLznData() {
            return false;
        }
    };
    public static final ImageDatumType LznType = new ImageDatumType("LZN"){

        @Override
        public boolean isInstance(ImageDatum datum) {
            ImageMetadata meta = datum.getMetadata(true);
            ImageType type = meta.getImageType();
            return type instanceof LZNImageType;
        }

        @Override
        public boolean hasLznData() {
            return true;
        }
    };
    public static final ImageDatumType JpegType = new ImageDatumType("JPEG"){

        @Override
        public boolean isInstance(ImageDatum datum) {
            LznEncoding encoding;
            ImageMetadata meta = datum.getMetadata(true);
            ImageType type = meta.getImageType();
            return type instanceof JPEGImageType && (encoding = ImageDatumType.getLznEncoding(datum)) == null;
        }

        @Override
        public boolean hasLznData() {
            return false;
        }
    };
    public static final ImageDatumType TiffType = new ImageDatumType("TIFF"){

        @Override
        public boolean isInstance(ImageDatum datum) {
            LznEncoding encoding;
            ImageMetadata meta = datum.getMetadata(true);
            ImageType type = meta.getImageType();
            return type instanceof TIFFImageType && (encoding = ImageDatumType.getLznEncoding(datum)) == null;
        }

        @Override
        public boolean hasLznData() {
            return false;
        }
    };
    public static final ImageDatumType JpegSidecarType = new ImageDatumType("JPEG-LZN"){

        @Override
        public boolean isInstance(ImageDatum datum) {
            LznEncoding encoding = ImageDatumType.getLznEncoding(datum);
            return encoding == LznEncoding.JPEG;
        }

        @Override
        public boolean hasLznData() {
            return true;
        }
    };
    public static final ImageDatumType TiffSidecarType = new ImageDatumType("TIFF-LZN"){

        @Override
        public boolean isInstance(ImageDatum datum) {
            LznEncoding encoding = ImageDatumType.getLznEncoding(datum);
            return encoding == LznEncoding.TIFF_Sidecar;
        }

        @Override
        public boolean hasLznData() {
            return true;
        }
    };
    public static final ImageDatumType TiffMultilayerType = new ImageDatumType("TIFF-MULTI"){

        @Override
        public boolean isInstance(ImageDatum datum) {
            LznEncoding encoding = ImageDatumType.getLznEncoding(datum);
            return encoding == LznEncoding.TIFF_Multilayer;
        }

        @Override
        public boolean hasLznData() {
            return true;
        }
    };
    public static final ImageDatumType UnknownType = new ImageDatumType("???"){

        @Override
        public boolean isInstance(ImageDatum datum) {
            return true;
        }

        @Override
        public boolean hasLznData() {
            return false;
        }
    };
    private String name;

    private ImageDatumType(String name) {
        this.name = name;
    }

    static ImageDatumType getTypeOf(ImageDatum datum) {
        if (RawType.isInstance(datum)) {
            return RawType;
        }
        if (LznType.isInstance(datum)) {
            return LznType;
        }
        LznEncoding encoding = ImageDatumType.getLznEncoding(datum);
        if (encoding == null) {
            if (JpegType.isInstance(datum)) {
                return JpegType;
            }
            if (TiffType.isInstance(datum)) {
                return TiffType;
            }
            return UnknownType;
        }
        switch (encoding) {
            case LZN: {
                return LznType;
            }
            case JPEG: {
                return JpegSidecarType;
            }
            case TIFF_Sidecar: {
                return TiffSidecarType;
            }
            case TIFF_Multilayer: {
                return TiffMultilayerType;
            }
        }
        return UnknownType;
    }

    public abstract boolean isInstance(ImageDatum var1);

    public abstract boolean hasLznData();

    public String toString() {
        return this.name;
    }

    private static LznEncoding getLznEncoding(ImageDatum datum) {
        ImageMetadata meta = datum.getMetadata(true);
        ImageType type = meta.getImageType();
        if (type instanceof LZNImageType) {
            return LznEncoding.LZN;
        }
        if (type instanceof SidecarJPEGImageType) {
            return LznEncoding.JPEG;
        }
        if (type instanceof SidecarTIFFImageType) {
            return LznEncoding.TIFF_Sidecar;
        }
        if (type instanceof MultipageTIFFImageType) {
            return LznEncoding.TIFF_Multilayer;
        }
        return null;
    }

    private static enum LznEncoding {
        LZN,
        JPEG,
        TIFF_Sidecar,
        TIFF_Multilayer;

    }
}

