/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.model;

import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.JPEGImageType;
import java.awt.image.RenderedImage;
import java.io.File;

abstract class ImageFileStrategy {
    static ImageFileStrategy JPEGStrategy = new ImageFileStrategy(){

        @Override
        RenderedImage maybeGetImage(ImageInfo info, int maxImageSize) throws Exception {
            File file;
            long length;
            ImageType imageType = info.getImageType();
            if (imageType instanceof JPEGImageType && (length = (file = info.getFile()).length()) < 0x3200000L) {
                JPEGImageType jpeg = (JPEGImageType)imageType;
                return jpeg.getImage(info, null, maxImageSize, maxImageSize);
            }
            return null;
        }
    };
    static ImageFileStrategy PreviewStrategy = new ImageFileStrategy(){

        @Override
        RenderedImage maybeGetImage(ImageInfo info, int maxImageSize) throws Exception {
            return info.getPreviewImage(maxImageSize, maxImageSize);
        }
    };
    static ImageFileStrategy ThumbnailStrategy = new ImageFileStrategy(){

        @Override
        RenderedImage maybeGetImage(ImageInfo info, int maxImageSize) throws Exception {
            if (maxImageSize <= 320) {
                return info.getThumbnailImage();
            }
            return null;
        }
    };
    static ImageFileStrategy FullStrategy = new ImageFileStrategy(){

        @Override
        RenderedImage maybeGetImage(ImageInfo info, int maxImageSize) throws Exception {
            File file = info.getFile();
            long length = file.length();
            if (length < 0xC800000L) {
                return info.getImage(null);
            }
            return null;
        }
    };
    static ImageFileStrategy[] Strategies = new ImageFileStrategy[]{JPEGStrategy, ThumbnailStrategy, PreviewStrategy, FullStrategy};

    ImageFileStrategy() {
    }

    RenderedImage getImage(ImageInfo info, int maxImageSize) {
        try {
            return this.maybeGetImage(info, maxImageSize);
        }
        catch (Throwable t) {
            this.logNonFatal(t, info);
            return null;
        }
    }

    abstract RenderedImage maybeGetImage(ImageInfo var1, int var2) throws Exception;

    private void logNonFatal(Throwable t, ImageInfo info) {
        File file = info.getFile();
        StringBuffer buffer = new StringBuffer();
        buffer.append(t.getClass().getName());
        buffer.append(" while fetching preview for ");
        buffer.append(file.getAbsolutePath());
        buffer.append(": ");
        buffer.append(t.getMessage());
        System.err.println(buffer);
    }
}

