/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.model;

import com.lightcrafts.image.ImageFileFilter;
import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.model.ImageList;
import com.lightcrafts.utils.file.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;

class ImageListPoller
implements Runnable {
    private static final long Interval = 3000L;
    private ImageList list;
    private File directory;
    private Thread thread = new Thread((Runnable)this, "Image List Poller");
    private boolean pause;
    private boolean stop;

    ImageListPoller(ImageList list, File directory) {
        this.thread.setPriority(1);
        this.list = list;
        this.directory = directory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stop) {
            ImageListPoller imageListPoller = this;
            synchronized (imageListPoller) {
                try {
                    this.poll();
                    this.wait(3000L);
                    if (this.pause) {
                        this.wait();
                    }
                }
                catch (Throwable e) {
                    if (e instanceof InterruptedException) {
                        continue;
                    }
                    System.err.println("Error in ImageListPoller:");
                    e.printStackTrace();
                }
            }
        }
    }

    void start() {
        if (!this.thread.isAlive()) {
            this.stop = false;
            this.thread.start();
        }
    }

    void stop() {
        this.stop = true;
        this.thread.interrupt();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void pause() {
        ImageListPoller imageListPoller = this;
        synchronized (imageListPoller) {
            this.pause = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resume() {
        ImageListPoller imageListPoller = this;
        synchronized (imageListPoller) {
            this.pause = false;
            this.notifyAll();
        }
    }

    private void poll() {
        ArrayList<ImageDatum> data = this.list.getAllImageData();
        HashSet<File> listFiles = new HashSet<File>();
        Iterator i = data.iterator();
        while (i.hasNext() && !this.stop) {
            ImageDatum datum = (ImageDatum)i.next();
            long oldTime = datum.getFileCacheTime();
            File file = datum.getFile();
            listFiles.add(file);
            if (oldTime <= 0L) continue;
            if (!file.isFile()) {
                ImageListPoller.log("file disappeared", file);
                this.list.removeImageData(datum);
            } else {
                long newTime = file.lastModified();
                if (newTime > oldTime) {
                    ImageListPoller.log("modification detected", file);
                    datum.refresh(false);
                    this.list.metadataChanged(datum);
                }
            }
            File xmpFile = datum.getXmpFile();
            if (xmpFile == null) continue;
            long oldXmpTime = datum.getXmpFileCacheTime();
            if (!xmpFile.isFile() && oldXmpTime > 0L) {
                ImageListPoller.log("XMP file disappeared", file);
                datum.refresh(true);
                this.list.metadataChanged(datum);
                continue;
            }
            if (xmpFile.lastModified() <= oldXmpTime) continue;
            ImageListPoller.log("XMP modification detected", file);
            datum.refresh(true);
            this.list.metadataChanged(datum);
        }
        File[] dirFiles = FileUtil.listFiles(this.directory, ImageFileFilter.INSTANCE, false);
        if (dirFiles != null) {
            for (int n = 0; n < dirFiles.length && !this.stop; ++n) {
                File file = dirFiles[n];
                if (listFiles.contains(file)) continue;
                ImageListPoller.log("file appeared", file);
                this.list.addFile(file);
            }
        }
    }

    private static void log(String message, File file) {
        System.out.println(message + " at " + file);
    }
}

