/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.platform.Platform;
import com.lightcrafts.prefs.ApplicationMode;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.model.ImageDatumComparator;
import com.lightcrafts.ui.browser.model.ImageDatumObserver;
import com.lightcrafts.ui.browser.model.ImageDatumType;
import com.lightcrafts.ui.browser.model.ImageGroup;
import com.lightcrafts.ui.browser.model.ImageGroupProvider;
import com.lightcrafts.ui.browser.model.ImageList;
import com.lightcrafts.ui.browser.model.ImageListListener;
import com.lightcrafts.ui.browser.model.PreviewUpdater;
import com.lightcrafts.ui.browser.view.DisabledLabel;
import com.lightcrafts.ui.browser.view.ExternalBrowserAction;
import com.lightcrafts.ui.browser.view.FileActions;
import com.lightcrafts.ui.browser.view.ImageBrowserActions;
import com.lightcrafts.ui.browser.view.ImageBrowserEvent;
import com.lightcrafts.ui.browser.view.ImageBrowserListener;
import com.lightcrafts.ui.browser.view.ImageBrowserMouseListener;
import com.lightcrafts.ui.browser.view.ImageBrowserMulticaster;
import com.lightcrafts.ui.browser.view.ImageBrowserSelectionModel;
import com.lightcrafts.ui.browser.view.ImageBrowserTransferHandler;
import com.lightcrafts.ui.browser.view.ImageDatumControl;
import com.lightcrafts.ui.browser.view.ImageDatumRenderer;
import com.lightcrafts.ui.browser.view.ImagePreservationQueue;
import com.lightcrafts.ui.browser.view.Locale;
import com.lightcrafts.ui.browser.view.RatingActions;
import com.lightcrafts.ui.browser.view.RotateActions;
import com.lightcrafts.ui.browser.view.SelectionAction;
import com.lightcrafts.ui.browser.view.SingleImageBrowserSelectionModel;
import com.lightcrafts.ui.browser.view.TemplateProvider;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceAdapter;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.Scrollable;
import javax.swing.Timer;

public abstract class AbstractImageBrowser
extends JComponent
implements Scrollable,
ImageDatumObserver,
ImageListListener {
    public static final Color Background = LightZoneSkin.Colors.BrowserBackground;
    ImageList list;
    int count;
    ImageDatumRenderer renderer;
    ImageBrowserSelectionModel selection;
    ImagePreservationQueue recentImages;
    ImageDatumControl controller;
    boolean isWidthInitialized;
    boolean isDisabled;
    private HashMap<ImageDatum, Integer> datumIndex;
    private LinkedList<ImageDatum> previews;
    private ImageBrowserMulticaster listeners;
    private TemplateProvider templates;
    private PreviewUpdater.Provider previewer;
    private ImageBrowserActions actions;
    private List<ExternalBrowserAction> externalActions;
    private int across;
    private boolean sizePausedFlag;
    private DragSourceAdapter dragSrcAdapter;
    private int copyOrMove;
    public boolean justShown = true;
    final Timer paintTimer = new Timer(300, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractImageBrowser.this.justShown = false;
            AbstractImageBrowser.this.paintTimer.stop();
            AbstractImageBrowser.this.repaint();
        }
    });
    private long lastAutoSelectionTime;

    AbstractImageBrowser(ImageList list) {
        this.list = list;
        this.count = this.getAllImageData().size();
        this.selection = ApplicationMode.isBasicMode() ? new SingleImageBrowserSelectionModel(this) : new ImageBrowserSelectionModel(this);
        this.previews = new LinkedList();
        this.externalActions = new LinkedList<ExternalBrowserAction>();
        this.datumIndex = new HashMap();
        this.rebuildIndex();
        list.addImageListListener(this);
        this.renderer = new ImageDatumRenderer();
        this.controller = new ImageDatumControl(this);
        ImageBrowserMouseListener mouseHandler = new ImageBrowserMouseListener(this, this.selection, this.controller);
        this.addMouseListener(mouseHandler);
        this.addMouseMotionListener(mouseHandler);
        this.listeners = new ImageBrowserMulticaster();
        this.actions = new ImageBrowserActions(this);
        this.recentImages = new ImagePreservationQueue();
        this.setBackground(Background);
        this.initKeyMaps();
        ImageBrowserTransferHandler transfer = new ImageBrowserTransferHandler(this, this.selection);
        this.setTransferHandler(transfer);
        DragSource src = DragSource.getDefaultDragSource();
        DragGestureListener init = transfer.createDragInitiator();
        src.createDefaultDragGestureRecognizer(this, 3, init);
        this.dragSrcAdapter = new DragSourceAdapter(){

            @Override
            public void dragDropEnd(DragSourceDropEvent dsde) {
                AbstractImageBrowser.this.copyOrMove = dsde.getDropAction();
            }
        };
        src.addDragSourceListener(this.dragSrcAdapter);
        this.updateEnabled();
        this.across = 1;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                AbstractImageBrowser.this.inferAcross();
                if (!AbstractImageBrowser.this.isWidthInitialized) {
                    AbstractImageBrowser.this.isWidthInitialized = true;
                }
            }
        });
    }

    Rectangle getBounds(ImageDatum datum) {
        Integer index = this.datumIndex.get(datum);
        if (index != null) {
            Rectangle bounds = this.getBounds(index);
            return bounds;
        }
        return null;
    }

    int getIndex(Point p) {
        int size = this.getCharacteristicSize();
        int row = p.y / size;
        int col = p.x / size;
        if (col >= this.across) {
            return -1;
        }
        int index = row * this.across + col;
        ArrayList<ImageDatum> datums = this.getAllImageData();
        int count = datums.size();
        if (index >= count) {
            return -1;
        }
        return index;
    }

    int[] getIndices(int count, Rectangle rect) {
        int size = this.getCharacteristicSize();
        int left = rect.x / size;
        int right = (rect.x + rect.width) / size + 1;
        int top = rect.y / size;
        int bottom = (rect.y + rect.height) / size + 1;
        int[] indices = new int[(right - left + 1) * (bottom - top + 1)];
        int i = 0;
        for (int y = top; y <= bottom; ++y) {
            for (int x = left; x <= right; ++x) {
                int index = y * this.across + x;
                if (index > count - 1) continue;
                indices[i++] = index;
            }
        }
        while (i < indices.length) {
            indices[i++] = -1;
        }
        return indices;
    }

    int getIndexBelow(int index) {
        if (this.getImageDatum(index + this.across) != null) {
            return index + this.across;
        }
        return -1;
    }

    int getIndexAbove(int index) {
        if (this.getImageDatum(index - this.across) != null) {
            return index - this.across;
        }
        return -1;
    }

    private int getIndexLeft(int index) {
        if (this.getImageDatum(index - 1) != null) {
            return index - 1;
        }
        return -1;
    }

    private int getIndexRight(int index) {
        if (this.getImageDatum(index + 1) != null) {
            return index + 1;
        }
        return -1;
    }

    public void setCharacteristicSize(int size, boolean isAdjusting) {
        if (isAdjusting && !this.sizePausedFlag) {
            this.list.pause();
            this.sizePausedFlag = true;
        } else if (!isAdjusting && this.sizePausedFlag) {
            this.list.resume();
            this.sizePausedFlag = false;
        }
        this.setCharacteristicSize(size);
        this.inferAcross();
        this.revalidate();
    }

    public int wasCopyOrMove() {
        return this.copyOrMove;
    }

    public void setCharacteristicSize(int size) {
        if (size != this.list.getSize()) {
            this.list.setSize(size);
            this.revalidate();
        }
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return this.getCharacteristicSize();
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        switch (orientation) {
            case 0: {
                return visibleRect.width;
            }
            case 1: {
                return visibleRect.height;
            }
        }
        return 1;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return this.isDisabled;
    }

    @Override
    protected abstract void paintComponent(Graphics var1);

    public ArrayList<File> getSelectedFiles() {
        ArrayList<File> files = new ArrayList<File>();
        for (ImageDatum datum : this.selection.getSelected()) {
            File file = datum.getFile();
            files.add(file);
        }
        return files;
    }

    public File getLeadSelectedFile() {
        ImageDatum datum = this.selection.getLeadSelected();
        return datum != null ? datum.getFile() : null;
    }

    @Override
    public void imageChanged(ImageDatum datum) {
        Integer i = this.datumIndex.get(datum);
        if (i != null) {
            Rectangle rect = this.getBounds(i);
            this.repaint(rect);
        }
        if (this.selection.getSelected().contains(datum)) {
            this.notifySelectionChanged();
        }
    }

    @Override
    public Dimension getPreferredSize() {
        ArrayList<ImageDatum> datums = this.getAllImageData();
        int size = this.getCharacteristicSize();
        int width = this.across * size;
        int count = datums.size();
        int height = (int)(Math.ceil((double)count / (double)this.across) * (double)size);
        return new Dimension(width, height);
    }

    public Rectangle getBounds(int index) {
        int row = index / this.across;
        int col = index % this.across;
        int size = this.getCharacteristicSize();
        return new Rectangle(col * size, row * size, size, size);
    }

    public int getCharacteristicSize() {
        return this.list.getSize();
    }

    public void addBrowserListener(ImageBrowserListener listener) {
        this.listeners.add(listener);
    }

    public void removeBrowserListener(ImageBrowserListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    @Override
    public void imageAdded(ImageList source, ImageDatum datum, int index) {
        this.rebuildIndex();
        this.updateEnabled();
        this.revalidate();
        this.repaint();
        this.count = this.getAllImageData().size();
        long time = System.currentTimeMillis();
        if (time - this.lastAutoSelectionTime > 30000L) {
            this.selection.setSelected(Collections.singletonList(datum));
        } else {
            this.notifySelectionChanged();
        }
        this.lastAutoSelectionTime = time;
    }

    @Override
    public void imageRemoved(ImageList source, ImageDatum datum, int index) {
        this.updateSelectionDatumRemoved(datum, index);
        this.rebuildIndex();
        this.updateEnabled();
        this.revalidate();
        this.repaint();
        this.count = this.getAllImageData().size();
        this.notifySelectionChanged();
    }

    void updateSelectionDatumRemoved(ImageDatum datum, int index) {
        List<ImageDatum> selected = this.selection.getSelected();
        if (selected.contains(datum)) {
            if (selected.size() == 1) {
                ImageDatum next = this.getImageDatum(index + 1);
                if (next == null) {
                    next = this.getImageDatum(index - 1);
                }
                if (next != null) {
                    this.selection.setLeadSelected(next);
                    Rectangle bounds = this.getBounds(index);
                    this.scrollRectToVisible(bounds);
                }
            } else {
                this.selection.removeSelected(datum);
            }
        }
    }

    @Override
    public void imagesReordered(ImageList source) {
        this.rebuildIndex();
        this.revalidate();
        this.repaint();
    }

    public void setSort(ImageDatumComparator comp) {
        this.list.setSort(comp);
    }

    public void setSortInverted(boolean inverted) {
        this.list.setSortInverted(inverted);
    }

    public void setTemplateProvider(TemplateProvider provider) {
        this.templates = provider;
    }

    public void setImageGroupProvider(ImageGroupProvider provider) {
        this.list.setImageGroupProvider(provider);
    }

    public void setPreviewProvider(PreviewUpdater.Provider provider) {
        this.previewer = provider;
    }

    public void addBrowserAction(ExternalBrowserAction action) {
        this.externalActions.add(action);
    }

    public ImageBrowserActions getActions() {
        return this.actions;
    }

    public void setSelectedFiles(Collection<File> files) {
        this.selection.clearSelected();
        ArrayList<ImageDatum> datums = this.getAllImageData();
        for (ImageDatum datum : datums) {
            if (!files.contains(datum.getFile())) continue;
            this.selection.setLeadSelected(datum);
            final ImageDatum finalDatum = datum;
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    Rectangle bounds = AbstractImageBrowser.this.getBounds(finalDatum);
                    if (bounds != null) {
                        AbstractImageBrowser.this.scrollRectToVisible(bounds);
                    }
                }
            });
            break;
        }
    }

    public void selectLatest() {
        ArrayList<ImageDatum> datums = this.getAllImageData();
        LinkedHashSet<ImageDatum> latest = new LinkedHashSet<ImageDatum>();
        for (ImageDatum datum : datums) {
            ImageGroup group = datum.getGroup();
            List<ImageDatum> members = group.getImageDatums();
            long time = 0L;
            ImageDatum recent = null;
            for (ImageDatum member : members) {
                File file = member.getFile();
                long t = file.lastModified();
                if (t <= time) continue;
                recent = member;
                time = t;
            }
            latest.add(recent);
        }
        this.selection.clearSelected();
        this.selection.addSelected(latest);
    }

    public void selectAll() {
        ArrayList<ImageDatum> datums = this.getAllImageData();
        this.selection.setSelected(datums);
    }

    public void clearSelection() {
        this.selection.clearSelected();
    }

    public int getImageCount() {
        return this.count;
    }

    abstract ArrayList<ImageDatum> getAllImageData();

    public void cancelTasks(Rectangle rect) {
        ArrayList<ImageDatum> datums = this.getAllImageData();
        int[] indices = this.getIndices(datums.size(), rect);
        HashSet<ImageDatum> excluded = new HashSet<ImageDatum>();
        for (int index : indices) {
            if (index < 0) continue;
            ImageDatum datum = datums.get(index);
            excluded.add(datum);
        }
        for (ImageDatum datum : datums) {
            if (excluded.contains(datum)) continue;
            datum.cancel();
        }
    }

    List<ExternalBrowserAction> getExternalBrowserActions() {
        return this.externalActions;
    }

    TemplateProvider getTemplateProvider() {
        return this.templates;
    }

    ImageDatum getImageDatum(int index) {
        Set<ImageDatum> datums = this.datumIndex.keySet();
        for (ImageDatum datum1 : datums) {
            ImageDatum datum = datum1;
            Integer n = this.datumIndex.get(datum);
            if (n != index) continue;
            return datum;
        }
        return null;
    }

    void addContinuousSelected(ImageDatum datum) {
        ImageDatum leadSelected = this.selection.getLeadSelected();
        if (leadSelected == null) {
            return;
        }
        Integer start = this.datumIndex.get(leadSelected);
        Integer end = this.datumIndex.get(datum);
        if (start != null && end != null) {
            if (end < start) {
                int temp = end;
                end = start;
                start = temp;
            }
            LinkedList<ImageDatum> selected = new LinkedList<ImageDatum>();
            for (int index = start.intValue(); index <= end; ++index) {
                ImageDatum d = this.getImageDatum(index);
                if (d == null) continue;
                selected.add(d);
            }
            this.selection.setSelected(selected);
        }
    }

    void showPopup(MouseEvent event) {
        JMenuItem item;
        JPopupMenu menu = new JPopupMenu();
        Point p = event.getPoint();
        int index = this.getIndex(p);
        if (index < 0) {
            return;
        }
        final ImageDatum datum = this.getImageDatum(index);
        ImageDatumType type = datum.getType();
        final ArrayList<File> files = this.getSelectedFiles();
        JMenuItem leftItem = new JMenuItem(Locale.LOCALE.get("LeftMenuItem"));
        leftItem.addActionListener(this.actions.getLeftAction());
        leftItem.setEnabled(this.actions.getLeftAction().isEnabled());
        menu.add(leftItem);
        JMenuItem rightItem = new JMenuItem(Locale.LOCALE.get("RightMenuItem"));
        rightItem.addActionListener(this.actions.getRightAction());
        rightItem.setEnabled(this.actions.getRightAction().isEnabled());
        menu.add(rightItem);
        JMenu ratingMenu = new JMenu(Locale.LOCALE.get("RatingItem"));
        List<SelectionAction> ratingActions = RatingActions.createRatingActions(this, false);
        SelectionAction clearAction = RatingActions.createClearRatingAction(this, false);
        for (SelectionAction action : ratingActions) {
            JMenuItem ratingItem = new JMenuItem(action);
            String name = (String)action.getValue("Name");
            if (Platform.getType() == Platform.Windows) {
                char star = '\u2605';
                if (name.length() > 0 && name.charAt(0) == star) {
                    ratingItem.setFont(new Font("Serif", 0, 14));
                }
            }
            ratingMenu.add(ratingItem);
        }
        ratingMenu.addSeparator();
        JMenuItem clearRatingItem = new JMenuItem(clearAction);
        ratingMenu.add(clearRatingItem);
        menu.add(ratingMenu);
        menu.addSeparator();
        JMenuItem openItem = new JMenuItem(Locale.LOCALE.get("EditMenuItem"));
        openItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractImageBrowser.this.selection.setLeadSelected(datum);
                AbstractImageBrowser.this.notifyDoubleClicked(datum);
            }
        });
        menu.add(openItem);
        JMenuItem showItem = new JMenuItem(this.actions.getShowFileInFolderAction());
        menu.add(showItem);
        JMenuItem renameItem = new JMenuItem(Locale.LOCALE.get("RenameMenuItem"));
        renameItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileActions.renameFile(datum.getFile(), AbstractImageBrowser.this);
            }
        });
        renameItem.setEnabled(!ApplicationMode.isBasicMode());
        menu.add(renameItem);
        JMenuItem deleteAllItem = new JMenuItem(this.actions.getTrashAction());
        menu.add(deleteAllItem);
        menu.addSeparator();
        JMenuItem copyTemplate = new JMenuItem(Locale.LOCALE.get("CopyMenuItem"));
        copyTemplate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ImageBrowserActions.TemplateClipboard = datum.getFile();
            }
        });
        if (!type.hasLznData() || ApplicationMode.isBasicMode()) {
            copyTemplate.setEnabled(false);
        }
        menu.add(copyTemplate);
        JMenuItem applyTemplate = new JMenuItem(this.actions.getPasteAction());
        menu.add(applyTemplate);
        JMenu templateItem = new JMenu(Locale.LOCALE.get("ApplyMenuItem"));
        if (this.templates != null && !files.isEmpty() && !ApplicationMode.isBasicMode()) {
            List actions = this.templates.getTemplateActions();
            if (!actions.isEmpty()) {
                for (final Object action : actions) {
                    item = new JMenuItem(action.toString());
                    item.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent event) {
                            AbstractImageBrowser.this.templates.applyTemplateAction(action, files.toArray(new File[0]));
                        }
                    });
                    templateItem.add(item);
                }
            } else {
                templateItem.setEnabled(false);
            }
        } else {
            templateItem.setEnabled(false);
        }
        menu.add(templateItem);
        menu.addSeparator();
        for (final ExternalBrowserAction action : this.externalActions) {
            String name = action.getName();
            item = new JMenuItem(name);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    action.actionPerformed(datum.getFile(), files.toArray(new File[0]));
                }
            });
            menu.add(item);
        }
        menu.addSeparator();
        JMenuItem refreshItem = new JMenuItem(Locale.LOCALE.get("RefreshMenuItem"));
        refreshItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                datum.refresh(false);
            }
        });
        menu.add(refreshItem);
        menu.addSeparator();
        JMenuItem showTypes = new JMenuItem(this.actions.getShowHideTypesAction());
        menu.add(showTypes);
        menu.show(this, p.x, p.y);
    }

    void notifySelectionChanged() {
        ImageBrowserEvent event;
        ImageDatum leadSelected = this.selection.getLeadSelected();
        List<ImageDatum> selected = this.selection.getSelected();
        ImageDatum lead = leadSelected;
        if (lead == null && selected.size() == 1) {
            lead = selected.get(0);
        }
        if (lead != null) {
            PreviewUpdater preview = lead.getPreview(this.previewer);
            event = new ImageBrowserEvent(lead, selected, preview, this.getSelectedPreviews(), this.count);
        } else {
            event = new ImageBrowserEvent(null, selected, null, this.getSelectedPreviews(), this.count);
        }
        this.disposePreviews(selected);
        this.listeners.selectionChanged(event);
    }

    void notifyDoubleClicked(ImageDatum datum) {
        PreviewUpdater preview = datum.getPreview(this.previewer);
        ImageBrowserEvent event = new ImageBrowserEvent(datum, this.selection.getSelected(), preview, this.getSelectedPreviews(), this.count);
        this.disposePreviews(Collections.singleton(datum));
        this.listeners.imageDoubleClicked(event);
    }

    void notifyError(String message) {
        Toolkit.getDefaultToolkit().beep();
        this.listeners.browserError(message);
    }

    private void disposePreviews(Collection<ImageDatum> newPreviews) {
        HashSet<ImageDatum> disposable = new HashSet<ImageDatum>(this.previews);
        if (newPreviews != null) {
            disposable.removeAll(newPreviews);
        }
        for (ImageDatum datum : disposable) {
            datum.disposePreviews();
        }
        this.previews.clear();
        if (newPreviews != null) {
            this.previews.addAll(newPreviews);
        }
    }

    void repaint(ImageDatum datum) {
        Rectangle bounds = this.getBounds(datum);
        if (bounds != null) {
            this.repaint(bounds);
        }
    }

    ArrayList<ImageDatum> getSelectedDatums() {
        return new ArrayList<ImageDatum>(this.selection.getSelected());
    }

    ImageDatum getLeadSelectedDatum() {
        return this.selection.getLeadSelected();
    }

    void moveSelectionUp() {
        int index;
        ImageDatum lead = this.selection.getLeadSelected();
        if (lead != null && (index = this.datumIndex.get(lead).intValue()) >= 0 && (index = this.getIndexAbove(index)) >= 0) {
            ImageDatum datum = this.getImageDatum(index);
            this.selection.setLeadSelected(datum);
            Rectangle bounds = this.getBounds(index);
            this.scrollRectToVisible(bounds);
        }
    }

    void moveSelectionDown() {
        int index;
        ImageDatum lead = this.selection.getLeadSelected();
        if (lead != null && (index = this.datumIndex.get(lead).intValue()) >= 0 && (index = this.getIndexBelow(index)) >= 0) {
            ImageDatum datum = this.getImageDatum(index);
            this.selection.setLeadSelected(datum);
            Rectangle bounds = this.getBounds(index);
            this.scrollRectToVisible(bounds);
        }
    }

    void moveSelectionLeft() {
        int index;
        ImageDatum lead = this.selection.getLeadSelected();
        if (lead != null && (index = this.datumIndex.get(lead).intValue()) >= 0 && (index = this.getIndexLeft(index)) >= 0) {
            ImageDatum datum = this.getImageDatum(index);
            this.selection.setLeadSelected(datum);
            Rectangle bounds = this.getBounds(index);
            this.scrollRectToVisible(bounds);
        }
    }

    void moveSelectionRight() {
        int index;
        ImageDatum lead = this.selection.getLeadSelected();
        if (lead != null && (index = this.datumIndex.get(lead).intValue()) >= 0 && (index = this.getIndexRight(index)) >= 0) {
            ImageDatum datum = this.getImageDatum(index);
            this.selection.setLeadSelected(datum);
            Rectangle bounds = this.getBounds(index);
            this.scrollRectToVisible(bounds);
        }
    }

    void moveSelectionNext() {
        ImageDatum datum;
        int index;
        ImageDatum lead = this.selection.getLeadSelected();
        if (lead != null && (index = this.datumIndex.get(lead).intValue()) >= 0 && (datum = this.getImageDatum(index + 1)) != null) {
            this.selection.setLeadSelected(datum);
            Rectangle bounds = this.getBounds(index);
            this.scrollRectToVisible(bounds);
        }
    }

    private ArrayList<PreviewUpdater> getSelectedPreviews() {
        List<ImageDatum> selected = this.selection.getSelected();
        ArrayList<PreviewUpdater> previews = new ArrayList<PreviewUpdater>();
        for (ImageDatum datum : selected) {
            PreviewUpdater preview = datum.getPreview(this.previewer);
            previews.add(preview);
        }
        return previews;
    }

    private void rebuildIndex() {
        this.datumIndex.clear();
        ArrayList<ImageDatum> data = this.getAllImageData();
        int n = 0;
        for (ImageDatum datum : data) {
            this.datumIndex.put(datum, n++);
        }
    }

    private void updateEnabled() {
        if (this.datumIndex.size() == 0) {
            this.setDisabled();
        } else {
            this.setEnabled();
        }
    }

    private void setEnabled() {
        if (this.isDisabled) {
            this.removeAll();
            this.isDisabled = false;
        }
    }

    private void setDisabled() {
        if (!this.isDisabled) {
            this.removeAll();
            this.setLayout(new BorderLayout());
            this.add(new DisabledLabel(Locale.LOCALE.get("NoImagesLabel")));
            this.isDisabled = true;
        }
    }

    private void inferAcross() {
        Dimension dim = this.getSize();
        int size = this.getCharacteristicSize();
        this.across = dim.width / size;
        this.across = this.across > 0 ? this.across : 1;
    }

    private void initKeyMaps() {
        this.setFocusable(true);
        this.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AbstractImageBrowser.this.moveSelectionUp();
            }
        }, KeyStroke.getKeyStroke(38, 0), 0);
        this.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AbstractImageBrowser.this.moveSelectionDown();
            }
        }, KeyStroke.getKeyStroke(40, 0), 0);
        this.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AbstractImageBrowser.this.moveSelectionLeft();
            }
        }, KeyStroke.getKeyStroke(37, 0), 0);
        this.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                AbstractImageBrowser.this.moveSelectionRight();
            }
        }, KeyStroke.getKeyStroke(39, 0), 0);
        this.registerKeyboardAction(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ImageDatum lead = AbstractImageBrowser.this.selection.getLeadSelected();
                if (lead != null) {
                    AbstractImageBrowser.this.notifyDoubleClicked(lead);
                }
            }
        }, KeyStroke.getKeyStroke(10, 0), 0);
        if (!ApplicationMode.isBasicMode()) {
            AbstractAction deleteSelected = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    ArrayList<File> files = AbstractImageBrowser.this.getSelectedFiles();
                    if (!files.isEmpty()) {
                        FileActions.deleteFiles(files.toArray(new File[0]), AbstractImageBrowser.this);
                    }
                }
            };
            this.registerKeyboardAction(deleteSelected, KeyStroke.getKeyStroke(127, 0), 0);
            this.registerKeyboardAction(deleteSelected, KeyStroke.getKeyStroke(8, 0), 0);
            List<SelectionAction> ratings = RatingActions.createAllActions(this, true);
            for (SelectionAction action : ratings) {
                this.registerKeyboardAction(action, action.getKeyStroke(), 0);
            }
        }
        List<SelectionAction> rotations = RotateActions.createAllActions(this, true);
        for (SelectionAction action : rotations) {
            this.registerKeyboardAction(action, action.getKeyStroke(), 0);
        }
    }

    public void dispose() {
        DragSource src = DragSource.getDefaultDragSource();
        src.removeDragSourceListener(this.dragSrcAdapter);
    }
}

