/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JScrollBar;
import javax.swing.plaf.basic.BasicScrollPaneUI;

class BrowserScrollPaneUI
extends BasicScrollPaneUI {
    BrowserScrollPaneUI() {
    }

    static void scrollByUnits(JScrollBar scrollbar, int direction, int units) {
        for (int i = 0; i < units; ++i) {
            int delta = direction > 0 ? scrollbar.getUnitIncrement(direction) : -scrollbar.getUnitIncrement(direction);
            int oldValue = scrollbar.getValue();
            int newValue = oldValue + delta;
            if (delta > 0 && newValue < oldValue) {
                newValue = scrollbar.getMaximum();
            } else if (delta < 0 && newValue > oldValue) {
                newValue = scrollbar.getMinimum();
            }
            if (oldValue == newValue) break;
            scrollbar.setValue(newValue);
        }
    }

    static void scrollByBlock(JScrollBar scrollbar, int direction) {
        int oldValue = scrollbar.getValue();
        int blockIncrement = scrollbar.getBlockIncrement(direction);
        int delta = blockIncrement * (direction > 0 ? 1 : -1);
        int newValue = oldValue + delta;
        if (delta > 0 && newValue < oldValue) {
            newValue = scrollbar.getMaximum();
        } else if (delta < 0 && newValue > oldValue) {
            newValue = scrollbar.getMinimum();
        }
        scrollbar.setValue(newValue);
    }

    @Override
    protected MouseWheelListener createMouseWheelListener() {
        return new BrowserMouseWheelHandler();
    }

    class BrowserMouseWheelHandler
    implements MouseWheelListener {
        BrowserMouseWheelHandler() {
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            if (BrowserScrollPaneUI.this.scrollpane.isWheelScrollingEnabled() && e.getScrollAmount() != 0) {
                int direction;
                JScrollBar toScroll = BrowserScrollPaneUI.this.scrollpane.getVerticalScrollBar();
                if (!(toScroll != null && toScroll.isVisible() || (toScroll = BrowserScrollPaneUI.this.scrollpane.getHorizontalScrollBar()) != null && toScroll.isVisible())) {
                    return;
                }
                int n = direction = e.getWheelRotation() < 0 ? -1 : 1;
                if (e.getScrollType() == 0) {
                    BrowserScrollPaneUI.scrollByUnits(toScroll, direction, 1);
                } else if (e.getScrollType() == 1) {
                    BrowserScrollPaneUI.scrollByBlock(toScroll, direction);
                }
            }
        }
    }
}

