/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.model.ImageDatumType;
import com.lightcrafts.ui.browser.model.ImageGroup;
import com.lightcrafts.ui.browser.model.ImageList;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import com.lightcrafts.ui.browser.view.ImageGroupCountRenderer;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;

public class CollapsedImageBrowser
extends AbstractImageBrowser {
    public CollapsedImageBrowser(ImageList list) {
        super(list);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Rectangle ctrlRect;
        if (this.justShown) {
            if (!this.paintTimer.isRunning()) {
                this.paintTimer.start();
            }
            return;
        }
        if (!this.isWidthInitialized) {
            return;
        }
        Graphics2D g = (Graphics2D)graphics;
        Rectangle clip = g.getClipBounds();
        ArrayList<ImageDatum> datums = this.getAllImageData();
        int[] indices = this.getIndices(datums.size(), clip);
        for (int i = indices.length - 1; i >= 0; --i) {
            ImageDatum datum;
            int index = indices[i];
            if (index < 0 || (datum = (ImageDatum)datums.get(index)) == null) continue;
            RenderedImage image = datum.getImage(this);
            this.recentImages.add(image);
            Rectangle rect = this.getBounds(index);
            g.setClip(clip.intersection(rect));
            File file = datum.getFile();
            String label = file.getName();
            ImageDatumType type = datum.getType();
            String tag = type.toString();
            ImageMetadata meta = datum.getMetadata(true);
            int rating = meta.getRating();
            boolean selected = this.selection.isSelected(datum);
            this.renderer.paint(g, image, label, tag, rating, rect, selected);
            ImageGroup group = datum.getGroup();
            if (!group.isNonTrivial()) continue;
            ImageGroupCountRenderer.paint(g, (Rectangle2D)rect, datum);
        }
        g.setClip(clip);
        if (this.controller.isEnabled() && (ctrlRect = this.controller.getRect()) != null && ctrlRect.intersects(clip)) {
            this.controller.paint(g);
        }
    }

    @Override
    ArrayList<ImageDatum> getAllImageData() {
        ArrayList<ImageDatum> allDatums = this.list.getAllImageData();
        LinkedHashSet<ImageDatum> recentDatums = new LinkedHashSet<ImageDatum>();
        for (ImageDatum datum : allDatums) {
            ImageGroup group = datum.getGroup();
            List<ImageDatum> members = group.getImageDatums();
            long lastTime = 0L;
            ImageDatum lastMember = null;
            for (ImageDatum member : members) {
                File file = member.getFile();
                long modTime = file.lastModified();
                if (modTime <= lastTime) continue;
                lastMember = member;
                lastTime = modTime;
            }
            recentDatums.add(lastMember);
        }
        return new ArrayList<ImageDatum>(recentDatums);
    }

    @Override
    void updateSelectionDatumRemoved(ImageDatum datum, int index) {
        List<ImageDatum> selected = this.selection.getSelected();
        if (selected.contains(datum)) {
            if (selected.size() == 1) {
                ArrayList<ImageDatum> visible = this.getAllImageData();
                ArrayList<ImageDatum> all = this.list.getAllImageData();
                ImageDatum next = null;
                if (index == 0) {
                    if (visible.size() > 0) {
                        next = visible.get(0);
                    }
                } else if (!datum.getType().hasLznData()) {
                    int max = all.size() - 1;
                    while (index < max && !visible.contains(next)) {
                        next = all.get(index++);
                    }
                } else {
                    while (index > 0 && !visible.contains(next)) {
                        next = all.get(--index);
                    }
                }
                if (next != null) {
                    int i = visible.indexOf(next);
                    this.selection.setLeadSelected(next);
                    if (i >= 0) {
                        Rectangle bounds = this.getBounds(i);
                        this.scrollRectToVisible(bounds);
                    }
                }
            } else {
                this.selection.removeSelected(datum);
            }
        }
    }
}

