/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.model.ImageDatumType;
import com.lightcrafts.ui.browser.model.ImageGroup;
import com.lightcrafts.ui.browser.model.ImageList;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.RenderedImage;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ExpandedImageBrowser
extends AbstractImageBrowser {
    public ExpandedImageBrowser(ImageList list) {
        super(list);
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
                System.out.println("Browser Shown");
            }

            @Override
            public void componentHidden(ComponentEvent e) {
                System.out.println("Browser Hidden");
                ExpandedImageBrowser.this.justShown = true;
            }
        });
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        Rectangle ctrlRect;
        if (this.justShown) {
            if (!this.paintTimer.isRunning()) {
                this.paintTimer.start();
            }
            return;
        }
        if (!this.isWidthInitialized) {
            return;
        }
        Graphics2D g = (Graphics2D)graphics;
        Rectangle clip = g.getClipBounds();
        ArrayList<ImageDatum> datums = this.getAllImageData();
        int[] indices = this.getIndices(datums.size(), clip);
        Color oldColor = g.getColor();
        g.setColor(LightZoneSkin.Colors.BrowserGroupColor);
        for (int i = indices.length - 1; i >= 0; --i) {
            RectangularShape highlight;
            ImageDatum datum;
            int index = indices[i];
            if (index < 0 || (datum = (ImageDatum)datums.get(index)) == null) continue;
            RenderedImage image = datum.getImage(this);
            this.recentImages.add(image);
            Rectangle rect = this.getBounds(index);
            g.setClip(clip.intersection(rect));
            if (this.isGroupStart(datums, index)) {
                highlight = new RoundRectangle2D.Double(rect.x + 4, rect.y + 4, 2 * rect.width - 8, rect.height - 8, rect.width / 8, rect.height / 8);
                g.fill(highlight);
            } else if (this.isGroupEnd(datums, index)) {
                highlight = new RoundRectangle2D.Double(rect.x - rect.width + 4, rect.y + 4, 2 * rect.width - 8, rect.height - 8, rect.width / 8, rect.height / 8);
                g.fill(highlight);
            } else if (datum.getGroup().isNonTrivial()) {
                highlight = new Rectangle(rect.x, rect.y + 4, rect.width, rect.height - 8);
                g.fill(highlight);
            }
            File file = datum.getFile();
            String label = file.getName();
            ImageDatumType type = datum.getType();
            String tag = type.toString();
            ImageMetadata meta = datum.getMetadata(true);
            int rating = meta.getRating();
            boolean selected = this.selection.isSelected(datum);
            this.renderer.paint(g, image, label, tag, rating, rect, selected);
        }
        g.setColor(oldColor);
        g.setClip(clip);
        if (this.controller.isEnabled() && (ctrlRect = this.controller.getRect()) != null && ctrlRect.intersects(clip)) {
            this.controller.paint(g);
        }
    }

    @Override
    ArrayList<ImageDatum> getAllImageData() {
        return this.list.getAllImageData();
    }

    private boolean isGroupStart(List<ImageDatum> datums, int index) {
        ImageDatum datum = datums.get(index);
        ImageGroup group = datum.getGroup();
        if (!group.isNonTrivial()) {
            return false;
        }
        if (index == 0) {
            return true;
        }
        ImageDatum prev = datums.get(index - 1);
        return group != prev.getGroup();
    }

    private boolean isGroupEnd(List<ImageDatum> datums, int index) {
        ImageDatum datum = datums.get(index);
        ImageGroup group = datum.getGroup();
        if (!group.isNonTrivial()) {
            return false;
        }
        if (index == datums.size() - 1) {
            return true;
        }
        ImageDatum next = datums.get(index + 1);
        return group != next.getGroup();
    }
}

