/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

class ImageBrowserSelectionModel {
    private ImageDatum leadSelected;
    private LinkedList<ImageDatum> selected;
    private AbstractImageBrowser browser;

    ImageBrowserSelectionModel(AbstractImageBrowser browser) {
        this.browser = browser;
        this.selected = new LinkedList();
    }

    void setLeadSelected(ImageDatum datum) {
        if (this.leadSelected != datum) {
            this.leadSelected = datum;
            this.selected.clear();
            if (datum != null) {
                this.selected.add(datum);
            }
            this.browser.notifySelectionChanged();
            this.browser.repaint();
        }
    }

    void addSelected(ImageDatum datum) {
        if (!this.selected.contains(datum) && datum != null) {
            this.selected.add(datum);
            this.browser.notifySelectionChanged();
            this.browser.repaint(datum);
        }
    }

    void addSelected(Collection<ImageDatum> datums) {
        boolean added = false;
        for (ImageDatum datum : datums) {
            if (this.selected.contains(datum) || datum == null) continue;
            this.selected.add(datum);
            added = true;
            this.browser.repaint(datum);
        }
        if (added) {
            this.browser.notifySelectionChanged();
        }
    }

    void setSelected(List<ImageDatum> datums) {
        HashSet<ImageDatum> removed = new HashSet<ImageDatum>(this.selected);
        removed.removeAll(datums);
        LinkedList<ImageDatum> added = new LinkedList<ImageDatum>(datums);
        added.removeAll(this.selected);
        if (added.isEmpty() && removed.isEmpty()) {
            return;
        }
        for (ImageDatum datum : removed) {
            this.selected.remove(datum);
            this.browser.repaint(datum);
        }
        for (ImageDatum datum : added) {
            if (datum != null) {
                this.selected.add(datum);
            }
            this.browser.repaint(datum);
        }
        if (datums.size() == 1) {
            this.leadSelected = datums.get(0);
        }
        this.browser.notifySelectionChanged();
    }

    void removeSelected(ImageDatum datum) {
        if (this.selected.contains(datum)) {
            this.selected.remove(datum);
            if (this.leadSelected != null && this.leadSelected.equals(datum)) {
                this.leadSelected = null;
            }
            this.browser.notifySelectionChanged();
            this.browser.repaint(datum);
        }
    }

    void clearSelected() {
        if (!this.selected.isEmpty()) {
            for (ImageDatum datum : this.selected) {
                this.browser.repaint(datum);
            }
            this.leadSelected = null;
            this.selected.clear();
            this.browser.notifySelectionChanged();
        }
    }

    ImageDatum getLeadSelected() {
        return this.leadSelected;
    }

    List<ImageDatum> getSelected() {
        return new ArrayList<ImageDatum>(this.selected);
    }

    boolean isSelected(ImageDatum datum) {
        return this.selected.contains(datum);
    }

    boolean isLeadSelected(ImageDatum datum) {
        return this.leadSelected == datum;
    }
}

