/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.mediax.jai.BorderExtender;
import com.lightcrafts.mediax.jai.Interpolation;
import com.lightcrafts.mediax.jai.JAI;
import com.lightcrafts.platform.Platform;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.browser.view.ImageDatumRatingRenderer;
import com.lightcrafts.ui.browser.view.ImageDatumTypeRenderer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.util.prefs.Preferences;
import javax.swing.JLabel;

class ImageDatumRenderer {
    private static final Color SelectColor = LightZoneSkin.Colors.BrowserSelectHighlight;
    private static final Stroke SelectStroke = new BasicStroke(2.0f);
    private static final Insets ImageInset = new Insets(8, 8, 8, 8);
    private static final int TextHeight = Platform.getType() == Platform.MacOSX ? 19 : 14;
    private static final int TextGap = 4;
    private static final Color LabelBackground = LightZoneSkin.Colors.BrowserLabelBackground;
    private static final Color LabelForeground = LightZoneSkin.Colors.BrowserLabelForeground;
    private static final Preferences Prefs = Preferences.userRoot().node("/com/lightcrafts/ui/browser/view");
    private static final String ImageTypesKey = "ImageTypes";
    private static boolean ShowImageTypes = Prefs.getBoolean("ImageTypes", true);
    private JLabel label = new JLabel();
    private static final AffineTransform identityTransform = new AffineTransform();

    ImageDatumRenderer() {
        this.label.setHorizontalAlignment(0);
        this.label.setForeground(LabelForeground);
        this.label.setBackground(LabelBackground);
        this.label.setFont(new Font("SansSerif", 0, 10));
        this.label.setOpaque(true);
    }

    static void setShowImageTypes(boolean show) {
        if (show != ShowImageTypes) {
            ShowImageTypes = show;
            Prefs.putBoolean(ImageTypesKey, show);
        }
    }

    static boolean doesShowImageTypes() {
        return ShowImageTypes;
    }

    void paint(Graphics2D g, RenderedImage image, String text, String tag, int rating, Rectangle rect, boolean selected) {
        Dimension imageSize = new Dimension(image.getWidth(), image.getHeight());
        this.label.setText(text);
        Insets insets = new Insets(ImageDatumRenderer.ImageInset.top, ImageDatumRenderer.ImageInset.left, ImageDatumRenderer.ImageInset.bottom + TextHeight + 4, ImageDatumRenderer.ImageInset.right);
        if (selected) {
            Color oldColor = g.getColor();
            Stroke oldStroke = g.getStroke();
            g.setColor(SelectColor);
            g.setStroke(SelectStroke);
            g.drawRect(rect.x + 2, rect.y + 2, rect.width - 4, rect.height - 4);
            g.setStroke(oldStroke);
            g.setColor(oldColor);
        }
        AffineTransform imageXform = ImageDatumRenderer.getImageXform(rect, insets, imageSize);
        RenderedImage xformedImage = image;
        if (!imageXform.isIdentity()) {
            RenderingHints extenderHints = new RenderingHints(JAI.KEY_BORDER_EXTENDER, BorderExtender.createInstance((int)1));
            ParameterBlock params = new ParameterBlock();
            params.addSource(image);
            params.add(imageXform);
            params.add(Interpolation.getInstance((int)1));
            xformedImage = JAI.create((String)"Affine", (ParameterBlock)params, (RenderingHints)extenderHints);
        }
        g.drawRenderedImage(xformedImage, identityTransform);
        Rectangle textRect = ImageDatumRenderer.getTextRectangle(rect);
        AffineTransform oldXform = g.getTransform();
        Color oldColor = g.getColor();
        g.translate(textRect.x, textRect.y);
        this.label.setBounds(textRect);
        this.label.paint(g);
        g.setColor(oldColor);
        g.setTransform(oldXform);
        if (rating > 0) {
            ImageDatumRatingRenderer.paint(g, rect, rating);
        }
        if (ShowImageTypes) {
            ImageDatumTypeRenderer.paint(g, (Rectangle2D)rect, tag);
        }
    }

    static Rectangle getTextRectangle(Rectangle rect) {
        Insets insets = new Insets(ImageDatumRenderer.ImageInset.top, ImageDatumRenderer.ImageInset.left, ImageDatumRenderer.ImageInset.bottom + TextHeight + 4, ImageDatumRenderer.ImageInset.right);
        Rectangle textRect = new Rectangle(rect.x + insets.left + 4, rect.y + rect.height - insets.bottom + 4, rect.width - insets.right - insets.left - 8, TextHeight);
        return textRect;
    }

    private static AffineTransform getImageXform(Rectangle rect, Insets insets, Dimension image) {
        double gap;
        Dimension bound = rect.getSize();
        double hSpace = bound.width - insets.left - insets.right;
        double vSpace = bound.height - insets.top - insets.bottom;
        double sWide = hSpace / (double)image.width;
        double sTall = vSpace / (double)image.height;
        double s = Math.min(sWide, sTall);
        AffineTransform xform = AffineTransform.getScaleInstance(s, s);
        if (sWide < sTall) {
            gap = (double)insets.top + (vSpace - (double)image.height * s) / 2.0;
            AffineTransform trans = AffineTransform.getTranslateInstance(insets.left, gap);
            xform.preConcatenate(trans);
        } else {
            gap = (double)insets.left + (hSpace - (double)image.width * s) / 2.0;
            AffineTransform trans = AffineTransform.getTranslateInstance(gap, insets.top);
            xform.preConcatenate(trans);
        }
        AffineTransform trans = AffineTransform.getTranslateInstance(rect.x, rect.y);
        xform.preConcatenate(trans);
        return xform;
    }
}

