/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.model.ImageDatumType;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import com.lightcrafts.ui.browser.view.Locale;
import com.lightcrafts.ui.browser.view.SelectionAction;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.KeyStroke;

class RotateActions {
    RotateActions() {
    }

    static List<SelectionAction> createAllActions(AbstractImageBrowser browser, boolean dynamic) {
        ArrayList<SelectionAction> actions = new ArrayList<SelectionAction>();
        actions.addAll(RotateActions.createRotateActions(browser, dynamic));
        actions.addAll(RotateActions.createRotateAdvanceActions(browser, dynamic));
        return actions;
    }

    static List<SelectionAction> createRotateAdvanceActions(AbstractImageBrowser browser, boolean dynamic) {
        ArrayList<SelectionAction> actions = new ArrayList<SelectionAction>();
        actions.add(RotateActions.createRotateLeftAdvanceAction(browser, dynamic));
        actions.add(RotateActions.createRotateRightAdvanceAction(browser, dynamic));
        return actions;
    }

    static List<SelectionAction> createRotateActions(AbstractImageBrowser browser, boolean dynamic) {
        ArrayList<SelectionAction> actions = new ArrayList<SelectionAction>();
        actions.add(RotateActions.createRotateLeftAction(browser, dynamic));
        actions.add(RotateActions.createRotateRightAction(browser, dynamic));
        return actions;
    }

    static SelectionAction createRotateLeftAdvanceAction(final AbstractImageBrowser browser, boolean dynamic) {
        SelectionAction action = new SelectionAction(Locale.LOCALE.get("LeftAdvanceMenuItem"), browser, KeyStroke.getKeyStroke(91, 64), dynamic, true){

            @Override
            public void actionPerformed(ActionEvent e) {
                RotateActions.rotateLeftAndAdvance(browser);
            }

            @Override
            void update() {
                this.setEnabled(RotateActions.hasNonLznSelection(this));
            }
        };
        return action;
    }

    static SelectionAction createRotateRightAdvanceAction(final AbstractImageBrowser browser, boolean dynamic) {
        SelectionAction action = new SelectionAction(Locale.LOCALE.get("RightAdvanceMenuItem"), browser, KeyStroke.getKeyStroke(93, 64), dynamic, true){

            @Override
            public void actionPerformed(ActionEvent e) {
                RotateActions.rotateRightAndAdvance(browser);
            }

            @Override
            void update() {
                this.setEnabled(RotateActions.hasNonLznSelection(this));
            }
        };
        return action;
    }

    static SelectionAction createRotateLeftAction(final AbstractImageBrowser browser, boolean dynamic) {
        SelectionAction action = new SelectionAction(Locale.LOCALE.get("LeftMenuItem"), browser, KeyStroke.getKeyStroke(91, 0), dynamic, true){

            @Override
            public void actionPerformed(ActionEvent e) {
                RotateActions.rotateLeft(browser);
            }

            @Override
            void update() {
                this.setEnabled(RotateActions.hasNonLznSelection(this));
            }
        };
        return action;
    }

    static SelectionAction createRotateRightAction(final AbstractImageBrowser browser, boolean dynamic) {
        SelectionAction action = new SelectionAction(Locale.LOCALE.get("RightMenuItem"), browser, KeyStroke.getKeyStroke(93, 0), dynamic, true){

            @Override
            public void actionPerformed(ActionEvent e) {
                RotateActions.rotateRight(browser);
            }

            @Override
            void update() {
                this.setEnabled(RotateActions.hasNonLznSelection(this));
            }
        };
        return action;
    }

    static void rotateLeftAndAdvance(AbstractImageBrowser browser) {
        RotateActions.rotateLeft(browser);
        browser.moveSelectionNext();
    }

    static void rotateRightAndAdvance(AbstractImageBrowser browser) {
        RotateActions.rotateRight(browser);
        browser.moveSelectionNext();
    }

    static void rotateLeft(AbstractImageBrowser browser) {
        ArrayList<ImageDatum> datums = browser.getSelectedDatums();
        for (ImageDatum datum : datums) {
            RotateActions.rotateLeft(datum, browser);
        }
    }

    static void rotateRight(AbstractImageBrowser browser) {
        ArrayList<ImageDatum> datums = browser.getSelectedDatums();
        for (ImageDatum datum : datums) {
            RotateActions.rotateRight(datum, browser);
        }
    }

    static void rotateLeft(ImageDatum datum, AbstractImageBrowser browser) {
        try {
            datum.rotateLeft();
        }
        catch (Throwable t) {
            browser.notifyError(t.getMessage());
            System.err.println("Rotate left failed");
            t.printStackTrace();
        }
    }

    static void rotateRight(ImageDatum datum, AbstractImageBrowser browser) {
        try {
            datum.rotateRight();
        }
        catch (Throwable t) {
            browser.notifyError(t.getMessage());
            System.err.println("Rotate right failed");
            t.printStackTrace();
        }
    }

    private static boolean hasNonLznSelection(SelectionAction action) {
        List<ImageDatum> datums = action.getSelection();
        for (ImageDatum datum : datums) {
            ImageDatumType type = datum.getType();
            if (type.hasLznData()) continue;
            return true;
        }
        return false;
    }
}

