/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.browser.view;

import com.lightcrafts.ui.browser.model.ImageDatum;
import com.lightcrafts.ui.browser.view.AbstractImageBrowser;
import com.lightcrafts.ui.browser.view.ImageBrowserEvent;
import com.lightcrafts.ui.browser.view.ImageBrowserListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;

abstract class SelectionAction
extends AbstractAction
implements ImageBrowserListener {
    private List<ImageDatum> selection;
    private KeyStroke keystroke;

    SelectionAction(String name, AbstractImageBrowser browser, KeyStroke key, boolean dynamic, boolean enabled) {
        this.putValue("Name", name);
        this.selection = new ArrayList<ImageDatum>();
        this.keystroke = key;
        if (dynamic && enabled) {
            this.setEnabled(false);
            browser.addBrowserListener(this);
        } else if (!enabled) {
            this.setEnabled(false);
        }
    }

    KeyStroke getKeyStroke() {
        return this.keystroke;
    }

    @Override
    public void selectionChanged(ImageBrowserEvent event) {
        this.selection = event.getDatums();
        this.update();
    }

    @Override
    public void imageDoubleClicked(ImageBrowserEvent event) {
    }

    @Override
    public void browserError(String message) {
    }

    List<ImageDatum> getSelection() {
        return this.selection;
    }

    void update() {
        boolean empty = this.selection.isEmpty();
        this.setEnabled(!empty);
    }
}

