/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.crop;

import com.lightcrafts.ui.crop.AspectConstraint;
import com.lightcrafts.ui.crop.ConstraintMenu;
import com.lightcrafts.ui.crop.CropOverlay;
import com.lightcrafts.ui.crop.NumberTextField;
import com.lightcrafts.ui.crop.TransposeButton;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.Action;

class ConstraintModel {
    private static final Preferences Prefs = Preferences.userNodeForPackage(ConstraintModel.class);
    private static final String CropConstraintKey = "CropConstraint";
    private AspectConstraint constraint;
    private CropOverlay overlay;
    private NumberTextField numeratorField;
    private NumberTextField denominatorField;
    private TransposeButton transposeButton;
    private ConstraintMenu constraintMenu;
    private boolean isLocked;

    ConstraintModel() {
        String text = Prefs.get(CropConstraintKey, new AspectConstraint(4, 6).toString());
        this.constraint = AspectConstraint.fromString(text);
        this.isLocked = true;
    }

    Action createMenuAction(final AspectConstraint constraint) {
        return new AbstractAction(constraint.toString()){

            @Override
            public void actionPerformed(ActionEvent event) {
                ConstraintModel.this.setAspectConstraint(constraint);
            }
        };
    }

    NumberTextField.Listener getNumeratorListener() {
        return new NumberTextField.Listener(){

            @Override
            public void numberChanged(int numerator) {
                int denominator = ConstraintModel.this.constraint.getDenominator();
                ConstraintModel.this.constraint = new AspectConstraint(numerator, denominator);
                if (ConstraintModel.this.overlay != null) {
                    ConstraintModel.this.overlay.setAspectConstraint(ConstraintModel.this.constraint);
                }
                Prefs.put(ConstraintModel.CropConstraintKey, ConstraintModel.this.constraint.toString());
            }
        };
    }

    NumberTextField.Listener getDenominatorListener() {
        return new NumberTextField.Listener(){

            @Override
            public void numberChanged(int denominator) {
                int numerator = ConstraintModel.this.constraint.getNumerator();
                ConstraintModel.this.constraint = new AspectConstraint(numerator, denominator);
                if (ConstraintModel.this.overlay != null) {
                    ConstraintModel.this.overlay.setAspectConstraint(ConstraintModel.this.constraint);
                }
                Prefs.put(ConstraintModel.CropConstraintKey, ConstraintModel.this.constraint.toString());
            }
        };
    }

    void setOverlay(CropOverlay overlay) {
        this.overlay = overlay;
        if (this.isLocked) {
            overlay.setAspectConstraint(this.constraint);
        } else {
            overlay.setAspectConstraint(new AspectConstraint());
        }
    }

    void setNumeratorTextField(NumberTextField field) {
        this.numeratorField = field;
        this.numeratorField.setNumber(this.constraint.getNumerator());
    }

    void setDenominatorTextField(NumberTextField field) {
        this.denominatorField = field;
        this.denominatorField.setNumber(this.constraint.getDenominator());
    }

    void setTransposeButton(TransposeButton button) {
        this.transposeButton = button;
    }

    void setConstraintMenu(ConstraintMenu menu) {
        this.constraintMenu = menu;
    }

    AspectConstraint getAspectConstraint() {
        if (this.isLocked) {
            return this.constraint;
        }
        return new AspectConstraint();
    }

    void transpose() {
        this.setAspectConstraint(this.constraint.transpose());
    }

    void unlock() {
        this.isLocked = false;
        if (this.overlay != null) {
            this.overlay.setAspectConstraint(new AspectConstraint());
        }
        this.numeratorField.setEnabled(false);
        this.denominatorField.setEnabled(false);
        this.transposeButton.setEnabled(false);
        this.constraintMenu.setEnabled(false);
        if (this.numeratorField.isFocusOwner() || this.denominatorField.isFocusOwner()) {
            KeyboardFocusManager focus = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            focus.upFocusCycle();
        }
    }

    void lock() {
        this.isLocked = true;
        if (this.overlay != null) {
            this.overlay.setAspectConstraint(this.constraint);
        }
        this.numeratorField.setEnabled(true);
        this.denominatorField.setEnabled(true);
        this.transposeButton.setEnabled(true);
        this.constraintMenu.setEnabled(true);
    }

    private void setAspectConstraint(AspectConstraint constraint) {
        this.constraint = constraint;
        if (this.overlay != null) {
            this.overlay.setAspectConstraint(constraint);
        }
        this.syncTextFields();
        Prefs.put(CropConstraintKey, constraint.toString());
    }

    private void syncTextFields() {
        int numerator = this.constraint.getNumerator();
        this.numeratorField.setNumber(numerator);
        int denominator = this.constraint.getDenominator();
        this.denominatorField.setNumber(denominator);
    }
}

