/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.crop;

import com.lightcrafts.ui.LightZoneSkin;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;

public class NumberTextField
extends JTextField
implements DocumentListener {
    private static final FocusListener FocusSelector = new FocusAdapter(){

        @Override
        public void focusGained(FocusEvent event) {
            NumberTextField text = (NumberTextField)event.getSource();
            text.selectAll();
        }
    };
    private static final NumberFormat IntegerFormat = NumberFormat.getIntegerInstance();
    private Listener listener;

    public NumberTextField(Listener listener) {
        this.fixSize();
        this.setNumber(0);
        this.listener = listener;
        this.setHorizontalAlignment(4);
        this.setInputVerifier(new PositiveNumberVerifier());
        Document doc = this.getDocument();
        doc.addDocumentListener(this);
        this.addFocusListener(FocusSelector);
        this.registerKeyboardActions();
    }

    public void setNumber(int n) {
        String text = IntegerFormat.format(n);
        this.setText(text);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.handleDocumentChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.handleDocumentChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.handleDocumentChange();
    }

    public int getNumber() {
        InputVerifier verifier = this.getInputVerifier();
        boolean verified = verifier.verify(this);
        if (!verified) {
            throw new IllegalStateException("Invalid number text");
        }
        String text = this.getText();
        int n = 0;
        try {
            Number number = IntegerFormat.parse(text);
            n = number.intValue();
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
        }
        return n;
    }

    private void registerKeyboardActions() {
        ActionListener upAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InputVerifier verifier = NumberTextField.this.getInputVerifier();
                if (!verifier.verify(NumberTextField.this)) {
                    return;
                }
                int n = NumberTextField.this.getNumber();
                NumberTextField.this.setNumber(++n);
            }
        };
        ActionListener downAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                InputVerifier verifier = NumberTextField.this.getInputVerifier();
                if (!verifier.verify(NumberTextField.this)) {
                    return;
                }
                int n = NumberTextField.this.getNumber();
                if (n > 1) {
                    NumberTextField.this.setNumber(--n);
                }
            }
        };
        this.registerKeyboardAction(upAction, "Increment", KeyStroke.getKeyStroke(38, 0), 0);
        this.registerKeyboardAction(downAction, "Decrement", KeyStroke.getKeyStroke(40, 0), 0);
    }

    private void handleDocumentChange() {
        InputVerifier verifier = this.getInputVerifier();
        boolean verified = verifier.verify(this);
        if (!verified) {
            this.setForeground(Color.red);
        } else {
            this.setForeground(LightZoneSkin.Colors.ToolPanesForeground);
            if (this.listener != null) {
                int n = this.getNumber();
                this.listener.numberChanged(n);
            }
        }
    }

    private void fixSize() {
        this.setText("100");
        Dimension size = this.getPreferredSize();
        this.setMinimumSize(size);
        this.setPreferredSize(size);
        this.setMaximumSize(size);
    }

    public static void main(String[] args) {
        NumberTextField text = new NumberTextField(new Listener(){

            @Override
            public void numberChanged(int number) {
                System.out.println(number);
            }
        });
        JFrame frame = new JFrame("NumberTextField Test");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().setLayout(new FlowLayout());
        frame.getContentPane().add(text);
        frame.pack();
        frame.setLocation(100, 100);
        frame.setVisible(true);
    }

    static {
        IntegerFormat.setParseIntegerOnly(false);
    }

    private class PositiveNumberVerifier
    extends InputVerifier {
        private PositiveNumberVerifier() {
        }

        @Override
        public boolean verify(JComponent input) {
            String text = NumberTextField.this.getText();
            ParsePosition pos = new ParsePosition(0);
            IntegerFormat.parse(text, pos);
            int index = pos.getIndex();
            if (index <= 0 || index != text.length()) {
                return false;
            }
            try {
                Number number = IntegerFormat.parse(text);
                int n = number.intValue();
                return n > 0;
            }
            catch (ParseException e) {
                return false;
            }
        }
    }

    public static interface Listener {
        public void numberChanged(int var1);
    }
}

