/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.model.CropBounds;
import com.lightcrafts.model.Engine;
import com.lightcrafts.ui.crop.CropListener;
import com.lightcrafts.ui.crop.CropMode;
import com.lightcrafts.ui.editor.Editor;
import com.lightcrafts.ui.editor.Locale;
import com.lightcrafts.ui.editor.XFormModel;
import com.lightcrafts.ui.rotate.RotorControl;
import com.lightcrafts.ui.rotate.RotorListener;
import com.lightcrafts.ui.rotate.RotorMode;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.Action;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.UndoableEditSupport;

class CropRotateManager
implements RotorListener {
    private CropMode rotorMode;
    private CropMode cropMode;
    private RotorMode hiddenRotorMode;
    private CropBounds bounds;
    private boolean hasInvertedAspect;
    private Engine engine;
    private XFormModel xform;
    private UndoableEditSupport undo;
    private static final String AngleTag = "Angle";
    private static final String CropTag = "Crop";
    private static final String ULtag = "UpperLeft";
    private static final String URtag = "UpperRight";
    private static final String LLtag = "LowerLeft";
    private static final String LRtag = "LowerRight";
    private static final String Xtag = "X";
    private static final String Ytag = "Y";

    public void setEditor(Editor editor) {
        this.hiddenRotorMode.setEditor(editor);
    }

    CropRotateManager(Engine engine, XFormModel xform) {
        this.engine = engine;
        this.xform = xform;
        this.rotorMode = new CropMode(true);
        this.cropMode = new CropMode(false);
        this.hiddenRotorMode = new RotorMode();
        this.bounds = new CropBounds();
        this.undo = new UndoableEditSupport();
        this.cropMode.addCropListener(new LocalCropListener(CropTag));
        this.rotorMode.addCropListener(new LocalCropListener("Rotate"));
        this.hiddenRotorMode.addRotorListener(this);
    }

    CropMode getRotorMode() {
        return this.rotorMode;
    }

    CropMode getCropMode() {
        return this.cropMode;
    }

    Action getLeftAction() {
        RotorControl control = this.hiddenRotorMode.getControl();
        return control.getLeftAction();
    }

    Action getRightAction() {
        RotorControl control = this.hiddenRotorMode.getControl();
        return control.getRightAction();
    }

    void addUndoableEditListener(UndoableEditListener listener) {
        this.undo.addUndoableEditListener(listener);
    }

    void removeUndoableEditListener(UndoableEditListener listener) {
        this.undo.removeUndoableEditListener(listener);
    }

    @Override
    public void angleChanged(double angle, boolean isChanging, boolean isNinetyDegrees) {
        angle = -angle;
        if (!isChanging) {
            CropBounds newBounds = this.getNewBounds(angle, isNinetyDegrees);
            this.engine.setCropBounds(newBounds);
            if (!newBounds.isAngleOnly()) {
                this.cropMode.setCrop(newBounds);
            }
            this.xform.update();
            this.postEdit(newBounds, Locale.LOCALE.get("RotateEditName"), true);
        }
    }

    @Override
    public void angleReset() {
        this.angleChanged(0.0, false, this.hasInvertedAspect);
    }

    private CropBounds getNewBounds(double angle, boolean invertAspect) {
        if (this.bounds.isAngleOnly()) {
            return new CropBounds(angle);
        }
        if (invertAspect) {
            CropBounds inverted = this.bounds.createInvertedAspect();
            this.hasInvertedAspect = !this.hasInvertedAspect;
            return new CropBounds(inverted, angle);
        }
        return new CropBounds(this.bounds, angle);
    }

    private void postEdit(final CropBounds newBounds, final String name, final boolean significant) {
        final CropBounds oldBounds = this.bounds;
        this.bounds = newBounds;
        AbstractUndoableEdit edit = new AbstractUndoableEdit(){

            @Override
            public String getPresentationName() {
                return name;
            }

            @Override
            public void undo() {
                super.undo();
                CropRotateManager.this.bounds = oldBounds;
                CropRotateManager.this.engine.setCropBounds(CropRotateManager.this.bounds);
                CropRotateManager.this.xform.update();
                CropRotateManager.this.hiddenRotorMode.setAngle(-CropRotateManager.this.bounds.getAngle());
                CropRotateManager.this.cropMode.setCrop(CropRotateManager.this.bounds);
            }

            @Override
            public void redo() {
                super.redo();
                CropRotateManager.this.bounds = newBounds;
                CropRotateManager.this.engine.setCropBounds(CropRotateManager.this.bounds);
                CropRotateManager.this.xform.update();
                CropRotateManager.this.hiddenRotorMode.setAngle(-CropRotateManager.this.bounds.getAngle());
                CropRotateManager.this.cropMode.setCrop(CropRotateManager.this.bounds);
            }

            @Override
            public boolean isSignificant() {
                return significant;
            }
        };
        this.undo.postEdit(edit);
    }

    private CropBounds limitRotation(CropBounds crop) {
        double angle;
        double height;
        double width;
        Point2D center;
        double newAngle;
        double oldAngle = this.bounds != null ? this.bounds.getAngle() : 0.0;
        double d = newAngle = crop != null ? crop.getAngle() : 0.0;
        while (newAngle - oldAngle > 0.7853981633974483) {
            center = crop.getCenter();
            width = crop.getWidth();
            height = crop.getHeight();
            angle = crop.getAngle();
            crop = new CropBounds(center, height, width, angle - 1.5707963267948966);
            newAngle = crop.getAngle();
        }
        while (newAngle - oldAngle < -0.7853981633974483) {
            center = crop.getCenter();
            width = crop.getWidth();
            height = crop.getHeight();
            angle = crop.getAngle();
            crop = new CropBounds(center, height, width, angle + 1.5707963267948966);
            newAngle = crop.getAngle();
        }
        return crop;
    }

    private CropBounds getUncroppedBounds() {
        if (this.bounds == null) {
            return new CropBounds();
        }
        double angle = this.bounds.getAngle();
        angle = 1.5707963267948966 * (double)Math.round(angle / 1.5707963267948966);
        return new CropBounds(angle);
    }

    public void save(XmlNode node) {
        node = node.addChild(CropTag);
        if (this.bounds.isAngleOnly()) {
            double angle = this.bounds.getAngle();
            node.setAttribute(AngleTag, Double.toString(angle));
        } else {
            XmlNode ulNode = node.addChild(ULtag);
            Point2D ul = this.bounds.getUpperLeft();
            ulNode.setAttribute(Xtag, Double.toString(ul.getX()));
            ulNode.setAttribute(Ytag, Double.toString(ul.getY()));
            XmlNode urNode = node.addChild(URtag);
            Point2D ur = this.bounds.getUpperRight();
            urNode.setAttribute(Xtag, Double.toString(ur.getX()));
            urNode.setAttribute(Ytag, Double.toString(ur.getY()));
            XmlNode llNode = node.addChild(LLtag);
            Point2D ll = this.bounds.getLowerLeft();
            llNode.setAttribute(Xtag, Double.toString(ll.getX()));
            llNode.setAttribute(Ytag, Double.toString(ll.getY()));
            XmlNode lrNode = node.addChild(LRtag);
            Point2D lr = this.bounds.getLowerRight();
            lrNode.setAttribute(Xtag, Double.toString(lr.getX()));
            lrNode.setAttribute(Ytag, Double.toString(lr.getY()));
        }
    }

    public void restore(XmlNode node) throws XMLException {
        try {
            Point2D.Double lr;
            Point2D.Double ll;
            Point2D.Double ur;
            Point2D.Double ul;
            node = node.getChild(CropTag);
            try {
                XmlNode ulNode = node.getChild(ULtag);
                double x = Double.parseDouble(ulNode.getAttribute(Xtag));
                double y = Double.parseDouble(ulNode.getAttribute(Ytag));
                ul = new Point2D.Double(x, y);
                XmlNode urNode = node.getChild(URtag);
                x = Double.parseDouble(urNode.getAttribute(Xtag));
                y = Double.parseDouble(urNode.getAttribute(Ytag));
                ur = new Point2D.Double(x, y);
                XmlNode llNode = node.getChild(LLtag);
                x = Double.parseDouble(llNode.getAttribute(Xtag));
                y = Double.parseDouble(llNode.getAttribute(Ytag));
                ll = new Point2D.Double(x, y);
                XmlNode lrNode = node.getChild(LRtag);
                x = Double.parseDouble(lrNode.getAttribute(Xtag));
                y = Double.parseDouble(lrNode.getAttribute(Ytag));
                lr = new Point2D.Double(x, y);
            }
            catch (NumberFormatException e) {
                throw new XMLException("Invalid crop coordinates", e);
            }
            this.bounds = new CropBounds((Point2D)ul, ur, ll, lr);
        }
        catch (XMLException e1) {
            try {
                double angle = Double.parseDouble(node.getAttribute(AngleTag));
                Dimension size = this.engine.getNaturalSize();
                Rectangle2D.Double imageBounds = new Rectangle2D.Double(0.0, 0.0, size.width, size.height);
                this.bounds = new CropBounds((Rectangle2D)imageBounds, angle);
            }
            catch (XMLException e2) {
                throw new XMLException("No valid crop or rotate data: " + e1.getMessage() + ", " + e2.getMessage());
            }
        }
        this.engine.setCropBounds(this.bounds);
        this.cropMode.setCrop(this.bounds);
        this.hiddenRotorMode.setAngle(-this.bounds.getAngle());
        this.xform.update();
    }

    void dispose() {
        if (this.rotorMode != null) {
            this.rotorMode.dispose();
        }
        if (this.cropMode != null) {
            this.cropMode.dispose();
        }
        if (this.hiddenRotorMode != null) {
            this.hiddenRotorMode.dispose();
        }
    }

    private class LocalCropListener
    implements CropListener {
        private final String m_opName;

        LocalCropListener(String s) {
            this.m_opName = s;
        }

        @Override
        public void cropCommitted(CropBounds crop) {
            CropBounds newBounds = crop != null ? crop : new CropBounds();
            newBounds = CropRotateManager.this.limitRotation(newBounds);
            CropRotateManager.this.engine.setCropBounds(newBounds);
            double angle = newBounds.getAngle();
            CropRotateManager.this.hiddenRotorMode.setAngle(-angle);
            CropRotateManager.this.xform.update();
            CropRotateManager.this.postEdit(newBounds, Locale.LOCALE.get(this.m_opName + "EditName"), true);
        }

        @Override
        public void unCrop() {
            CropBounds newBounds = CropRotateManager.this.getUncroppedBounds();
            CropRotateManager.this.engine.setCropBounds(newBounds);
            CropRotateManager.this.xform.update();
        }
    }
}

