/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.ui.LightZoneSkin;
import com.lightcrafts.ui.editor.DocUndoManager;
import com.lightcrafts.ui.editor.Document;
import com.lightcrafts.ui.editor.EditorMode;
import com.lightcrafts.ui.editor.Locale;
import com.lightcrafts.ui.toolkit.PaneTitle;
import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoableEdit;

public final class DocUndoHistory
extends JPanel
implements UndoableEditListener {
    private DocUndoManager undo;
    private DefaultListModel model;
    private ListSelectionModel selection;
    private JScrollPane scroll;
    private JList list;
    private boolean isEditing;
    private boolean isSelecting;

    public DocUndoHistory() {
        this.setEnabled(false);
        this.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        this.setOpaque(true);
        this.setBorder(LightZoneSkin.getPaneBorder());
        this.setLayout(new BoxLayout(this, 1));
        this.list = new JList();
        this.list.setForeground(LightZoneSkin.Colors.ToolPanesForeground);
        this.list.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        this.list.setCellRenderer(new UndoCellRenderer());
        this.scroll = new JScrollPane(this.list);
        this.scroll.setHorizontalScrollBarPolicy(30);
        this.scroll.setVerticalScrollBarPolicy(20);
        this.scroll.setBorder(null);
        this.add(new PaneTitle(Locale.LOCALE.get("DocUndoHistoryTitle")));
        this.add(this.scroll);
    }

    public DocUndoHistory(Document doc) {
        this();
        this.setEnabled(true);
        this.undo = doc.getUndoManager();
        this.model = new DefaultListModel();
        this.model.addElement(Locale.LOCALE.get("DocUndoHistoryOriginalItem"));
        this.list.setModel(this.model);
        this.selection = this.list.getSelectionModel();
        this.selection.setSelectionMode(0);
        this.undo.addUndoableEditListener(this);
        this.selection.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!DocUndoHistory.this.isSelecting && !e.getValueIsAdjusting()) {
                    DocUndoHistory.this.getComboFrame().getEditor().setMode(EditorMode.ARROW);
                    DocUndoHistory.this.isEditing = true;
                    int selected = DocUndoHistory.this.selection.getLeadSelectionIndex();
                    int index = DocUndoHistory.this.model.size() - selected - 2;
                    System.out.println("selected index = " + index);
                    DocUndoHistory.this.undo.setEditIndex(index);
                    DocUndoHistory.this.isEditing = false;
                }
            }
        });
    }

    public JComponent getScrollPane() {
        return this.scroll;
    }

    public void horizontalMouseWheelMoved(MouseWheelEvent e) {
        if (e.getScrollType() >= 2 && this.scroll.isWheelScrollingEnabled()) {
            JScrollBar bar = this.scroll.getHorizontalScrollBar();
            int dir = e.getWheelRotation() < 0 ? -1 : 1;
            int inc = bar.getUnitIncrement(dir);
            int value = bar.getValue() - e.getWheelRotation() * inc;
            bar.setValue(value);
        }
    }

    public ComboFrame getComboFrame() {
        return (ComboFrame)SwingUtilities.getAncestorOfClass(ComboFrame.class, this);
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent event) {
        if (!this.isEditing) {
            this.isSelecting = true;
            this.model.clear();
            this.model.addElement(Locale.LOCALE.get("DocUndoHistoryOriginalItem"));
            this.selection.removeSelectionInterval(0, this.model.getSize());
            List<UndoableEdit> edits = this.undo.getEdits();
            for (UndoableEdit edit : edits) {
                this.model.insertElementAt(edit.getPresentationName(), 0);
            }
            int index = edits.size() - this.undo.getEditIndex() - 1;
            this.selection.setSelectionInterval(index, index);
            this.isSelecting = false;
        }
    }

    private static final class UndoCellRenderer
    extends JLabel
    implements ListCellRenderer {
        UndoCellRenderer() {
            this.setForeground(LightZoneSkin.Colors.ToolPanesForeground);
            this.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (cellHasFocus || isSelected) {
                this.setBackground(LightZoneSkin.Colors.ToolsBackground.darker().darker());
            } else {
                this.setBackground(LightZoneSkin.Colors.ToolPanesBackground);
            }
            this.setText((String)value);
            return this;
        }
    }
}

