/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.ui.editor.Document;
import com.lightcrafts.ui.editor.Editor;
import com.lightcrafts.ui.editor.EditorMode;
import com.lightcrafts.ui.editor.Locale;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;

class DocUndoManager
extends UndoManager {
    private Document doc;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private List<UndoableEdit> edits;
    private ListIterator<UndoableEdit> currentEdit;
    private List<UndoableEditListener> listeners;

    DocUndoManager(Document doc) {
        this.doc = doc;
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        this.edits = new LinkedList<UndoableEdit>();
        this.currentEdit = this.edits.listIterator();
        this.listeners = new LinkedList<UndoableEditListener>();
    }

    Action getUndoAction() {
        return this.undoAction;
    }

    Action getRedoAction() {
        return this.redoAction;
    }

    @Override
    public boolean addEdit(UndoableEdit edit) {
        boolean inProgress = super.addEdit(edit);
        if (edit.isSignificant()) {
            this.doc.markDirty();
            this.currentEdit.add(edit);
            while (this.currentEdit.hasNext()) {
                this.currentEdit.next();
                this.currentEdit.remove();
            }
        }
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
        return inProgress;
    }

    @Override
    public void undo() {
        Editor editor = this.doc.getEditor();
        EditorMode mode = editor.getMode();
        int numUndos = 1;
        if (mode == EditorMode.CROP || mode == EditorMode.ROTATE) {
            editor.setMode(EditorMode.ARROW);
            numUndos = 2;
        }
        for (int i = 0; i < numUndos; ++i) {
            super.undo();
            this.currentEdit.previous();
        }
        this.notifyListeners(null);
    }

    @Override
    public void redo() {
        super.redo();
        this.currentEdit.next();
        this.notifyListeners(null);
    }

    @Override
    public void discardAllEdits() {
        super.discardAllEdits();
        this.edits.clear();
        this.currentEdit = this.edits.listIterator();
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
    }

    List<UndoableEdit> getEdits() {
        return new LinkedList<UndoableEdit>(this.edits);
    }

    int getEditIndex() {
        return this.currentEdit.previousIndex();
    }

    void setEditIndex(int newIndex) {
        int index = this.getEditIndex();
        while (newIndex > index) {
            this.redoAction.actionPerformed(null);
            index = this.getEditIndex();
        }
        while (newIndex < index) {
            this.undoAction.actionPerformed(null);
            index = this.getEditIndex();
        }
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent event) {
        super.undoableEditHappened(event);
        this.notifyListeners(event);
    }

    void addUndoableEditListener(UndoableEditListener listener) {
        this.listeners.add(listener);
    }

    void removeUndoableEditListener(UndoableEditListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners(UndoableEditEvent event) {
        for (UndoableEditListener listener : this.listeners) {
            listener.undoableEditHappened(event);
        }
    }

    private final class RedoAction
    extends AbstractAction {
        RedoAction() {
            super(Locale.LOCALE.get("RedoActionName"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                DocUndoManager.this.redo();
            }
            catch (CannotRedoException e) {
                throw new RuntimeException(Locale.LOCALE.get("CannotRedoError"), e);
            }
            this.updateRedoState();
            DocUndoManager.this.undoAction.updateUndoState();
            if (DocUndoManager.this.undoAction.isEnabled()) {
                DocUndoManager.this.doc.markDirty();
            }
        }

        void updateRedoState() {
            if (DocUndoManager.this.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", DocUndoManager.this.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", Locale.LOCALE.get("RedoActionName"));
            }
        }
    }

    private final class UndoAction
    extends AbstractAction {
        UndoAction() {
            super(Locale.LOCALE.get("UndoActionName"));
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                DocUndoManager.this.undo();
            }
            catch (CannotUndoException e) {
                throw new RuntimeException(Locale.LOCALE.get("CannotUndoError"), e);
            }
            this.updateUndoState();
            DocUndoManager.this.redoAction.updateRedoState();
            if (!this.isEnabled()) {
                DocUndoManager.this.doc.markClean();
            }
        }

        void updateUndoState() {
            if (DocUndoManager.this.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", DocUndoManager.this.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", Locale.LOCALE.get("UndoActionName"));
            }
        }
    }
}

