/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ColorProfileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.export.ImageExportOptions;
import com.lightcrafts.image.metadata.ImageMetadata;
import com.lightcrafts.image.metadata.ImageOrientation;
import com.lightcrafts.mediax.jai.util.ImagingException;
import com.lightcrafts.model.Engine;
import com.lightcrafts.model.EngineFactory;
import com.lightcrafts.model.Scale;
import com.lightcrafts.ui.editor.CropRotateManager;
import com.lightcrafts.ui.editor.DisabledEditor;
import com.lightcrafts.ui.editor.DocUndoManager;
import com.lightcrafts.ui.editor.DocumentListener;
import com.lightcrafts.ui.editor.Editor;
import com.lightcrafts.ui.editor.Locale;
import com.lightcrafts.ui.editor.RegionManager;
import com.lightcrafts.ui.editor.RelativePathUtility;
import com.lightcrafts.ui.editor.ScaleListener;
import com.lightcrafts.ui.editor.ScaleModel;
import com.lightcrafts.ui.editor.TemporaryEditorCommitState;
import com.lightcrafts.ui.editor.XFormListener;
import com.lightcrafts.ui.editor.XFormModel;
import com.lightcrafts.ui.export.SaveOptions;
import com.lightcrafts.ui.print.PrintLayoutModel;
import com.lightcrafts.utils.UserCanceledException;
import com.lightcrafts.utils.thread.ProgressThread;
import com.lightcrafts.utils.xml.XMLException;
import com.lightcrafts.utils.xml.XmlDocument;
import com.lightcrafts.utils.xml.XmlNode;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.Action;

public class Document {
    public static final int SavedDocVersion = 8;
    private ImageMetadata meta;
    private SaveOptions save;
    private Editor editor;
    private Engine engine;
    private CropRotateManager crop;
    private RegionManager regions;
    private ScaleModel scale;
    private XFormModel xform;
    private PrintLayoutModel print;
    private DocUndoManager undo;
    private boolean dirty;
    private Collection<DocumentListener> listeners;
    private ImageExportOptions export;
    private Object source;
    private static final String ScaleTag = "Scale";
    private static final String ImageTag = "Image";
    private static final String ImagePathTag = "path";
    private static final String ImageOrientationTag = "orientation";
    private static final String ImageRelativePathTag = "relativePath";
    private static final String ControlTag = "Controls";
    private static final String SaveTag = "Save";
    private static final String PrintTag = "Print";
    private static final String ExportTag = "Export";

    public Document(XmlDocument doc) throws ColorProfileException, UserCanceledException, IOException, XMLException, MissingImageFileException, BadImageFileException, UnknownImageTypeException {
        this(doc, null);
    }

    public Document(XmlDocument doc, ImageMetadata meta) throws UserCanceledException, ColorProfileException, IOException, XMLException, MissingImageFileException, BadImageFileException, UnknownImageTypeException {
        this(doc, meta, null, null);
    }

    /*
     * Unable to fully structure code
     */
    public Document(XmlDocument doc, ImageMetadata meta, ImageInfo versionInfo, ProgressThread thread) throws XMLException, IOException, BadImageFileException, ColorProfileException, UnknownImageTypeException, UserCanceledException, MissingImageFileException, ImagingException {
        super();
        root = doc.getRoot();
        version = root.getVersion();
        if (version > 8) {
            throw new XMLException(Locale.LOCALE.get("FutureLznError"));
        }
        if (version < 0) {
            throw new XMLException(Locale.LOCALE.get("MissingLznVersionError"));
        }
        if (meta == null) {
            node = root.getChild("Image");
            path = node.getAttribute("path");
            file = new File(path);
            if (!file.isFile()) {
                throw new MissingImageFileException(file);
            }
            if (node.hasAttribute("relativePath") && (relativeFile = new File(path = node.getAttribute("relativePath"))).isFile()) {
                file = relativeFile;
            }
            info = ImageInfo.getInstanceFor(file);
            try {
                meta = info.getMetadata();
            }
            catch (FileNotFoundException e) {
                throw new MissingImageFileException(file);
            }
        }
        this.meta = meta;
        imageNode = root.getChild("Image");
        if (imageNode.hasAttribute("orientation")) {
            value = imageNode.getAttribute("orientation");
            try {
                oldOrientation = ImageOrientation.getOrientationFor(Short.parseShort(value));
                newOrientation = meta.getOrientation();
                if (oldOrientation == newOrientation) ** GOTO lbl37
                meta.setOrientation(oldOrientation);
            }
            catch (NumberFormatException e) {
                throw new XMLException("Image orientation \"" + value + "\" is not a number", e);
            }
        } else if (!root.getName().equals("Template")) {
            origOrient = meta.getOriginalOrientation();
            meta.setOrientation(origOrient);
        }
lbl37:
        // 5 sources

        this.engine = EngineFactory.createEngine(meta, versionInfo, thread);
        this.xform = new XFormModel(this.engine);
        this.regions = new RegionManager();
        this.crop = new CropRotateManager(this.engine, this.xform);
        this.scale = new ScaleModel(this.engine);
        scaleNode = root.getChild("Scale");
        s = new Scale(scaleNode);
        this.scale.setScale(s);
        this.editor = new Editor(this.engine, this.scale, this.xform, this.regions, this.crop, this);
        this.editor.showWait(Locale.LOCALE.get("EditorWaitText"));
        this.crop.setEditor(this.editor);
        controlNode = root.getChild("Controls");
        try {
            this.editor.restore(controlNode);
        }
        catch (XMLException e) {
            this.dispose();
            throw e;
        }
        this.commonInitialization();
        if (root.hasChild("Save")) {
            saveNode = root.getChild("Save");
            this.save = SaveOptions.restore(saveNode);
        }
        if (root.hasChild("Print")) {
            printNode = root.getChild("Print");
            size = this.engine.getNaturalSize();
            this.print = new PrintLayoutModel(size.width, size.height);
            this.print.restore(printNode);
        }
        if (root.hasChild("Export")) {
            exportNode = root.getChild("Export");
            this.export = ImageExportOptions.read(exportNode);
        }
    }

    public Document(ImageMetadata meta) throws UserCanceledException, ColorProfileException, IOException, BadImageFileException, UnknownImageTypeException {
        this(meta, null);
    }

    public Document(ImageMetadata meta, ProgressThread thread) throws BadImageFileException, ColorProfileException, ImagingException, IOException, UnknownImageTypeException, UserCanceledException {
        this.meta = meta;
        this.engine = EngineFactory.createEngine(meta, null, thread);
        this.xform = new XFormModel(this.engine);
        this.regions = new RegionManager();
        this.scale = new ScaleModel(this.engine);
        this.crop = new CropRotateManager(this.engine, this.xform);
        this.editor = new Editor(this.engine, this.scale, this.xform, this.regions, this.crop, this);
        this.crop.setEditor(this.editor);
        this.editor.showWait(Locale.LOCALE.get("EditorWaitText"));
        this.commonInitialization();
    }

    private void commonInitialization() {
        this.undo = new DocUndoManager(this);
        this.editor.addUndoableEditListener(this.undo);
        this.print = null;
        this.scale.addScaleListener(new ScaleListener(){

            @Override
            public void scaleChanged(Scale scale) {
                Document.this.xform.update();
            }
        });
        this.xform.addXFormListener(new XFormListener(){

            @Override
            public void xFormChanged(AffineTransform xform) {
                Document.this.regions.setXForm(xform);
            }
        });
        this.listeners = new LinkedList<DocumentListener>();
    }

    public void setSaveOptions(SaveOptions save) {
        this.save = save;
    }

    public SaveOptions getSaveOptions() {
        return this.save;
    }

    public File getFile() {
        return this.save != null ? this.save.getFile() : null;
    }

    public ImageMetadata getMetadata() {
        return this.meta;
    }

    public Editor getEditor() {
        return this.editor;
    }

    public static DisabledEditor createDisabledEditor(DisabledEditor.Listener listener) {
        return new DisabledEditor(listener);
    }

    public Engine getEngine() {
        return this.engine;
    }

    public Action getProofAction() {
        return this.editor.getProofAction();
    }

    public Action getRotateRightAction() {
        return this.crop.getRightAction();
    }

    public Action getRotateLeftAction() {
        return this.crop.getLeftAction();
    }

    public Action getUndoAction() {
        return this.undo.getUndoAction();
    }

    public Action getRedoAction() {
        return this.undo.getRedoAction();
    }

    DocUndoManager getUndoManager() {
        return this.undo;
    }

    public List<Action> getOperations() {
        return this.editor.getOperations();
    }

    public ScaleModel getScaleModel() {
        return this.scale;
    }

    public RegionManager getRegionManager() {
        return this.regions;
    }

    public void zoomToFit() {
        Rectangle rect = this.editor.getMaxImageBounds();
        if (rect.width > 0 && rect.height > 0) {
            Scale oldScale = this.scale.getCurrentScale();
            Scale newScale = this.engine.setScale(rect);
            if (!this.scale.setScale(newScale)) {
                this.engine.setScale(oldScale);
            }
        }
    }

    public void markClean() {
        if (this.dirty) {
            this.dirty = false;
            this.notifyListeners();
        }
    }

    public void markDirty() {
        if (!this.dirty) {
            this.dirty = true;
            this.notifyListeners();
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void pushFitMode() {
        this.editor.pushFitMode();
    }

    public boolean popFitMode() {
        return this.editor.popFitMode();
    }

    public void discardEdits() {
        this.undo.discardAllEdits();
    }

    public boolean hasRawAdjustments() {
        return this.editor.hasRawAdjustments();
    }

    public void setSource(Object source) {
        this.source = source;
    }

    public Object getSource() {
        return this.source;
    }

    public void addDocumentListener(DocumentListener listener) {
        this.listeners.add(listener);
    }

    public void removeDocumentListener(DocumentListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        for (DocumentListener listener : this.listeners) {
            listener.documentChanged(this, this.dirty);
        }
    }

    public PrintLayoutModel getPrintLayout() {
        if (this.print != null) {
            Dimension size = this.engine.getNaturalSize();
            this.print.updateImageSize(size.width, size.height);
        }
        return this.print;
    }

    public void setPrintLayout(PrintLayoutModel print) {
        this.print = print;
        this.markDirty();
    }

    public ImageExportOptions getExportOptions() {
        return this.export;
    }

    public void setExportOptions(ImageExportOptions options) {
        this.export = options;
        this.markDirty();
    }

    public void dispose() {
        this.editor.dispose();
        this.engine.dispose();
    }

    public TemporaryEditorCommitState saveStart() {
        return this.editor.saveStart();
    }

    public void saveEnd(TemporaryEditorCommitState state) {
        this.editor.saveEnd(state);
    }

    public void save(XmlNode node) {
        node.setVersion(8);
        XmlNode scaleNode = node.addChild(ScaleTag);
        this.scale.getCurrentScale().save(scaleNode);
        XmlNode imageNode = node.addChild(ImageTag);
        imageNode.setAttribute(ImagePathTag, this.meta.getFile().getAbsolutePath());
        imageNode.setAttribute(ImageOrientationTag, Integer.toString(this.meta.getOrientation().getTIFFConstant()));
        if (this.save != null) {
            String path;
            try {
                path = RelativePathUtility.getRelativePath(this.save.getFile(), this.meta.getFile());
            }
            catch (IOException e) {
                path = this.meta.getFile().getName();
            }
            imageNode.setAttribute(ImageRelativePathTag, path);
        }
        XmlNode controlNode = node.addChild(ControlTag);
        this.editor.save(controlNode);
        if (this.save != null) {
            XmlNode saveNode = node.addChild(SaveTag);
            this.save.save(saveNode);
        }
        if (this.print != null) {
            XmlNode printNode = node.addChild(PrintTag);
            this.print.save(printNode);
        }
        if (this.export != null) {
            XmlNode exportNode = node.addChild(ExportTag);
            this.export.write(exportNode);
        }
    }

    public void saveTemplate(XmlNode node) {
        node.setVersion(8);
        XmlNode scaleNode = node.addChild(ScaleTag);
        this.scale.getCurrentScale().save(scaleNode);
        XmlNode imageNode = node.addChild(ImageTag);
        imageNode.setAttribute(ImagePathTag, "");
        XmlNode controlNode = node.addChild(ControlTag);
        this.editor.save(controlNode);
    }

    public void applyTemplate(XmlNode node) throws XMLException {
        int version = node.getVersion();
        if (version > 8) {
            throw new XMLException(Locale.LOCALE.get("FutureTemplateError"));
        }
        if (version < 0) {
            throw new XMLException(Locale.LOCALE.get("MissingTemplateVersionError"));
        }
        XmlNode controlNode = node.getChild(ControlTag);
        this.editor.addControls(controlNode);
    }

    public void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public static void main(String[] args) throws Exception {
        FileInputStream in = new FileInputStream(args[0]);
        XmlDocument xml = new XmlDocument(in);
        Document doc = new Document(xml, null);
        RenderedImage image = doc.engine.getRendering(new Dimension(100, 100));
        ImageIO.write(image, "jpeg", new File("out.jpg"));
    }

    public class MissingImageFileException
    extends Exception {
        private File imageFile;

        private MissingImageFileException(File imageFile) {
            super(Locale.LOCALE.get("MissingImageError", imageFile.getPath()));
            this.imageFile = imageFile;
        }

        public File getImageFile() {
            return this.imageFile;
        }
    }
}

