/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.image.BadImageFileException;
import com.lightcrafts.image.ImageInfo;
import com.lightcrafts.image.UnknownImageTypeException;
import com.lightcrafts.image.types.ImageType;
import com.lightcrafts.image.types.LZNDocumentProvider;
import com.lightcrafts.image.types.LZNImageType;
import com.lightcrafts.ui.editor.LightweightDocument;
import com.lightcrafts.utils.LightCraftsException;
import com.lightcrafts.utils.xml.XmlDocument;
import com.lightcrafts.utils.xml.XmlNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.w3c.dom.Document;

public class DocumentReader {
    public static boolean isReadable(File file) {
        ImageInfo info = ImageInfo.getInstanceFor(file);
        try {
            return info.getImageType() instanceof LZNDocumentProvider;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static Interpretation read(File file) {
        ImageType type;
        XmlDocument xmlDoc = null;
        File imageFile = null;
        ImageInfo info = ImageInfo.getInstanceFor(file);
        try {
            type = info.getImageType();
        }
        catch (IOException e) {
            return null;
        }
        catch (LightCraftsException e) {
            if (file.getName().endsWith(".lzt")) {
                type = LZNImageType.INSTANCE;
            }
            return null;
        }
        if (type == LZNImageType.INSTANCE) {
            try {
                FileInputStream in = new FileInputStream(file);
                xmlDoc = new XmlDocument(in);
                LightweightDocument lwDoc = new LightweightDocument(file);
                imageFile = lwDoc.getImageFile();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (xmlDoc == null) {
            try {
                LZNDocumentProvider p;
                Document lznDoc;
                if (type instanceof LZNDocumentProvider && (lznDoc = (p = (LZNDocumentProvider)((Object)type)).getLZNDocument(info)) != null && (xmlDoc = new XmlDocument(lznDoc.getDocumentElement())) != null) {
                    XmlNode root = xmlDoc.getRoot();
                    XmlNode imageNode = root.getChild("Image");
                    if (imageNode.hasAttribute("self")) {
                        imageFile = file;
                    } else {
                        LightweightDocument lwDoc = new LightweightDocument(file, xmlDoc);
                        imageFile = lwDoc.getImageFile();
                    }
                }
            }
            catch (BadImageFileException e) {
                return null;
            }
            catch (IOException e) {
                return null;
            }
            catch (UnknownImageTypeException e) {
                return null;
            }
            catch (Throwable t) {
                System.out.println("Unexpected error in DocumentReader.read()");
                System.out.println(t.getClass().getName() + ": " + t.getMessage());
                return null;
            }
        }
        if (xmlDoc != null) {
            Interpretation interp = new Interpretation();
            interp.xml = xmlDoc;
            interp.imageFile = imageFile;
            interp.info = info;
            return interp;
        }
        return null;
    }

    public static class Interpretation {
        public XmlDocument xml;
        public File imageFile;
        public ImageInfo info;
    }
}

