/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.model.Region;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Point2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

class EeRegion {
    private static ArrayList<String> Names = new ArrayList();

    EeRegion() {
    }

    private static Shape justify(Shape shape) {
        Rectangle bounds = shape.getBounds();
        AffineTransform xform = AffineTransform.getTranslateInstance(-((RectangularShape)bounds).getX(), -((RectangularShape)bounds).getY());
        return xform.createTransformedShape(shape);
    }

    private static Shape stringToShape(Graphics2D g, String s, float size) {
        FontRenderContext context = g.getFontRenderContext();
        Font font = g.getFont();
        font = font.deriveFont(size);
        TextLayout text = new TextLayout(s, font, context);
        Shape shape = text.getOutline(null);
        shape = EeRegion.justify(shape);
        return shape;
    }

    static Region create(Graphics2D g, Dimension size) {
        int count = Names.size();
        Shape[] shapes = new Shape[count];
        double[] widths = new double[count];
        double[] heights = new double[count];
        float fontSize = 32.0f * (float)size.height / 400.0f;
        for (int n = 0; n < count; ++n) {
            String name = Names.get(n);
            Shape shape = EeRegion.stringToShape(g, name, fontSize);
            Rectangle bounds = shape.getBounds();
            shapes[n] = shape;
            widths[n] = ((RectangularShape)bounds).getWidth();
            heights[n] = ((RectangularShape)bounds).getHeight();
        }
        double maxHeight = 0.0;
        for (int n = 0; n < count; ++n) {
            maxHeight = Math.max(maxHeight, heights[n]);
        }
        double inset = ((double)size.height - (double)count * (maxHeight *= 1.3)) / 2.0;
        Area area = new Area();
        for (int n = 0; n < count; ++n) {
            double h = inset + (double)n * maxHeight;
            double w = ((double)size.width - widths[n]) / 2.0;
            AffineTransform xform = AffineTransform.getTranslateInstance(w, h);
            shapes[n] = xform.createTransformedShape(shapes[n]);
            area.add(new Area(shapes[n]));
        }
        ShapeRegion region = new ShapeRegion(area);
        return region;
    }

    static {
        ResourceBundle resources = ResourceBundle.getBundle("com/lightcrafts/ui/editor/resources/EeRegion");
        String Team = resources.getString("Team");
        StringTokenizer tokens = new StringTokenizer(Team, ",");
        while (tokens.hasMoreTokens()) {
            Names.add(tokens.nextToken());
        }
    }

    static class ShapeRegion
    implements Region {
        private Shape shape;

        ShapeRegion(Shape shape) {
            this.shape = shape;
        }

        @Override
        public Shape getOuterShape() {
            return this.shape;
        }

        @Override
        public float getWidth() {
            return 0.0f;
        }

        @Override
        public Point2D getTranslation() {
            return null;
        }

        @Override
        public Collection getContours() {
            return Collections.singleton(this);
        }
    }
}

