/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.model.Scale;
import com.lightcrafts.ui.editor.EditorMode;
import com.lightcrafts.ui.editor.Locale;
import com.lightcrafts.ui.editor.ScaleListener;
import com.lightcrafts.ui.editor.ScaleModel;
import com.lightcrafts.ui.toolkit.CoolButton;
import com.lightcrafts.ui.toolkit.IconFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;

final class LargerButton
extends CoolButton
implements ActionListener,
ScaleListener {
    private static Icon Icon = IconFactory.createInvertedIcon(LargerButton.class, "largescale.png");
    private static final String ToolTip = Locale.LOCALE.get("ZoomInToolTip");
    private ScaleModel scale;

    LargerButton(ScaleModel scale) {
        this.scale = scale;
        this.setStyle(CoolButton.ButtonStyle.CENTER);
        this.setIcon(Icon);
        this.setToolTipText(ToolTip);
        this.addActionListener(this);
        scale.addScaleListener(this);
    }

    LargerButton() {
        this.setIcon(Icon);
        this.setToolTipText(ToolTip);
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ComboFrame frame = this.getComboFrame();
        if (frame != null) {
            frame.getEditor().setMode(EditorMode.ARROW);
        }
        this.scale.scaleUp();
    }

    @Override
    public void scaleChanged(Scale s) {
        boolean canScaleUp = this.scale.canScaleUp();
        this.setEnabled(canScaleUp);
    }
}

