/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import com.lightcrafts.app.ComboFrame;
import com.lightcrafts.model.Scale;
import com.lightcrafts.ui.editor.EditorMode;
import com.lightcrafts.ui.editor.Locale;
import com.lightcrafts.ui.editor.ScaleListener;
import com.lightcrafts.ui.editor.ScaleModel;
import com.lightcrafts.ui.toolkit.CoolButton;
import com.lightcrafts.ui.toolkit.IconFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;

final class OneToOneButton
extends CoolButton
implements ActionListener,
ScaleListener {
    static final Scale Unity = new Scale(1, 1);
    private static Icon Icon = IconFactory.createInvertedIcon(OneToOneButton.class, "1to1.png");
    private static final String ToolTip = Locale.LOCALE.get("OneToOneToolTip");
    private ScaleModel scale;

    OneToOneButton(ScaleModel scale) {
        this.scale = scale;
        this.setStyle(CoolButton.ButtonStyle.LEFT);
        this.setIcon(Icon);
        this.setToolTipText(ToolTip);
        this.addActionListener(this);
        scale.addScaleListener(this);
    }

    OneToOneButton() {
        this.setIcon(Icon);
        this.setToolTipText(ToolTip);
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        ComboFrame frame = this.getComboFrame();
        if (frame != null) {
            frame.getEditor().setMode(EditorMode.ARROW);
        }
        this.scale.setScale(Unity);
    }

    @Override
    public void scaleChanged(Scale scale) {
        boolean isUnity = scale.equals(Unity);
        this.setEnabled(!isUnity);
    }
}

