/*
 * Decompiled with CFR 0.152.
 */
package com.lightcrafts.ui.editor;

import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class RelativePathUtility {
    RelativePathUtility() {
    }

    static String getRelativePath(File source, File target) throws IOException {
        File common = RelativePathUtility.getCommonAncestor(source = new File(source.getCanonicalPath()), target = new File(target.getCanonicalPath()));
        if (common == null) {
            return null;
        }
        String upPath = RelativePathUtility.getRelativeAncestor(common, source);
        String downPath = RelativePathUtility.getRelativeDescendant(common, target);
        String path = upPath.length() > 0 && downPath.length() > 0 ? upPath + File.separatorChar + downPath : upPath + downPath;
        return path;
    }

    static File getRelativeFile(File source, String path) {
        source = source.getParentFile();
        return new File(source, path);
    }

    static List<File> getAncestors(File file) {
        LinkedList<File> list = new LinkedList<File>();
        if ((file = file.getParentFile()) == null) {
            return list;
        }
        do {
            list.addFirst(file);
        } while ((file = file.getParentFile()) != null);
        return list;
    }

    static File getCommonAncestor(File f1, File f2) {
        File o2;
        File o1;
        List<File> a1 = RelativePathUtility.getAncestors(f1);
        List<File> a2 = RelativePathUtility.getAncestors(f2);
        Iterator<File> i1 = a1.iterator();
        Iterator<File> i2 = a2.iterator();
        File common = null;
        while (i1.hasNext() && i2.hasNext() && ((Object)(o1 = i1.next())).equals(o2 = i2.next())) {
            common = o1;
        }
        return common;
    }

    private static String getRelativeDescendant(File ancestor, File descendant) {
        File f;
        List<File> ancestors = RelativePathUtility.getAncestors(descendant);
        if (!ancestors.contains(ancestor)) {
            throw new IllegalArgumentException("The descendant \"" + descendant.getPath() + "\" " + "does not have ancestor \"" + ancestor.getPath() + "\".");
        }
        Iterator<File> i = ancestors.iterator();
        while (!ancestor.equals(f = i.next())) {
        }
        StringBuffer path = new StringBuffer();
        while (i.hasNext()) {
            f = i.next();
            path.append(f.getName());
            path.append(File.separatorChar);
        }
        path.append(descendant.getName());
        return path.toString();
    }

    private static String getRelativeAncestor(File ancestor, File descendant) {
        File f;
        List<File> ancestors = RelativePathUtility.getAncestors(descendant);
        if (!ancestors.contains(ancestor)) {
            throw new IllegalArgumentException("The file \"" + descendant.getPath() + "\" " + "does not have ancestor \"" + ancestor.getPath() + "\".");
        }
        Iterator<File> i = ancestors.iterator();
        while (!ancestor.equals(f = i.next())) {
        }
        StringBuffer path = new StringBuffer();
        while (i.hasNext()) {
            i.next();
            path.append("..");
            if (!i.hasNext()) continue;
            path.append(File.separatorChar);
        }
        return path.toString();
    }

    public static void main(String[] args) throws IOException {
        String s1 = "/a/b/c";
        String s2 = "/a/d/e";
        File f1 = new File(s1);
        File f2 = new File(s2);
        String path = RelativePathUtility.getRelativePath(f1, f2);
        System.out.println(path);
        File file = RelativePathUtility.getRelativeFile(f1, path);
        System.out.println(file.getPath());
    }
}

